/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.css;

import com.ibm.rave.core.css.CSSStyleRule;
import com.ibm.rave.core.css.CSSStyleSheet;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.css.CSSParser;
import com.ibm.rave.core.internal.css.om.CSSStyleRuleImpl;
import java.util.ArrayList;
import java.util.List;

public class CSSStyleSheetManager {
    public static CSSStyleSheetManager INSTANCE = new CSSStyleSheetManager();
    private OMap<String, List<CSSStyleRule>> idToStyleRules;
    private OMap<String, List<CSSStyleRule>> classToStyleRules;
    private OMap<String, List<CSSStyleRule>> tagToStyleRules;
    private final List<OMap<String, List<CSSStyleRule>>> allMaps = new ArrayList<OMap<String, List<CSSStyleRule>>>();
    private static final int UNKNOWN = -1;
    private static final int CLASS = 1;
    private static final int ID = 2;
    private static final int TAG = 3;

    public CSSStyleSheetManager() {
        this.initialize();
    }

    public void add(CSSStyleSheet stylesheet) {
        for (CSSStyleRule rule : stylesheet.getCssRules()) {
            if (rule.getSelectorText() == null) continue;
            this.addToCache(rule);
        }
    }

    private void initialize() {
        this.idToStyleRules = new OMap();
        this.classToStyleRules = new OMap();
        this.tagToStyleRules = new OMap();
        this.allMaps.clear();
        this.allMaps.add(this.idToStyleRules);
        this.allMaps.add(this.classToStyleRules);
        this.allMaps.add(this.tagToStyleRules);
    }

    public void clear() {
        this.initialize();
    }

    public List<CSSStyleRule> getPotentialMatchesByClass(String className) {
        return this.classToStyleRules.get(className);
    }

    public List<CSSStyleRule> getPotentialMatchesById(String id) {
        return this.idToStyleRules.get(id);
    }

    public List<CSSStyleRule> getPotentialMatchesByTag(String tag) {
        return this.tagToStyleRules.get(tag);
    }

    private void addToCache(CSSStyleRule styleRule) {
        for (String selector : CSSParser.splitSelectorText(styleRule.getSelectorText())) {
            String[] matches;
            List<String> parts = CSSParser.deconstructSelectorText(selector);
            String dominant = parts.get(parts.size() - 1);
            for (String match : matches = CSSStyleSheetManager.splitSelectorTextByTypes(dominant)) {
                if (match.length() == 0) continue;
                OMap<String, List<CSSStyleRule>> matchingMap = null;
                switch (CSSStyleSheetManager.determineSelectorType(match)) {
                    case 3: {
                        matchingMap = this.tagToStyleRules;
                        break;
                    }
                    case 2: {
                        matchingMap = this.idToStyleRules;
                        break;
                    }
                    case 1: {
                        matchingMap = this.classToStyleRules;
                        break;
                    }
                }
                if (matchingMap == null) continue;
                List<CSSStyleRule> rules = matchingMap.get(match);
                int insertIndex = 0;
                if (rules == null) {
                    rules = new ArrayList<CSSStyleRule>();
                    matchingMap.put(match, rules);
                } else {
                    for (int i = 0; i < rules.size(); ++i) {
                        CSSStyleRule existingRule = rules.get(i);
                        if (CSSStyleSheetManager.determineSpecificity((CSSStyleRuleImpl)styleRule) >= CSSStyleSheetManager.determineSpecificity((CSSStyleRuleImpl)existingRule)) break;
                        ++insertIndex;
                    }
                }
                rules.add(insertIndex, styleRule);
            }
        }
    }

    private static String[] splitSelectorTextByTypes(String selector) {
        return selector.replaceAll(",", " ").split("(?=[\\.\\#\\s])");
    }

    private static int determineSpecificity(CSSStyleRuleImpl styleRule) {
        if (styleRule._specificity > 0) {
            return styleRule._specificity;
        }
        int specificity = 0;
        block5: for (String selector : CSSStyleSheetManager.splitSelectorTextByTypes(styleRule.getSelectorText())) {
            switch (CSSStyleSheetManager.determineSelectorType(selector)) {
                case 3: {
                    ++specificity;
                    continue block5;
                }
                case 2: {
                    specificity += 256;
                    continue block5;
                }
                case 1: {
                    specificity += 16;
                    continue block5;
                }
            }
        }
        styleRule._specificity = specificity;
        return specificity;
    }

    private static int determineSelectorType(String selectorText) {
        if (selectorText == null) {
            return -1;
        }
        char firstChar = selectorText.charAt(0);
        if (firstChar == '#') {
            return 2;
        }
        if (firstChar == '.' || firstChar == ':') {
            return 1;
        }
        return 3;
    }

    public boolean remove(CSSStyleSheet styleSheet) {
        boolean result = false;
        for (OMap<String, List<CSSStyleRule>> map : this.allMaps) {
            for (String key : map.keySet()) {
                List<CSSStyleRule> list = map.get(key);
                for (int i = 0; i < list.size(); ++i) {
                    CSSStyleRule rule = list.get(i);
                    if (rule.getParentStyleSheet() != styleSheet) continue;
                    list.remove(i--);
                    result = true;
                }
                if (list.size() != 0) continue;
                map.remove(key);
            }
        }
        return result;
    }
}

