/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.rave.core.internal.geo.PathContextStreamListener;

public class BufferPathContextStreamListener
extends DelegatingStreamListener
implements PathContextStreamListener {
    private String pointCircle;
    private final ArrayEx<String> buffer = new ArrayEx();
    private static final String BLANK = "";

    public BufferPathContextStreamListener() {
        this.pointCircle = this.pathBufferCircle(4.5);
        final BufferPathContextStreamListener self = this;
        final DelegatingStreamListener.StreamPointStateHandler point = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                self.buffer.push("M", BufferPathContextStreamListener.dblToStr(x), ",", BufferPathContextStreamListener.dblToStr(y), self.pointCircle);
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler pointLine = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                self.buffer.push("L", BufferPathContextStreamListener.dblToStr(x), ",", BufferPathContextStreamListener.dblToStr(y));
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler pointLineStart = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                self.buffer.push("M", BufferPathContextStreamListener.dblToStr(x), ",", BufferPathContextStreamListener.dblToStr(y));
                self.setPointDelegate(pointLine);
            }
        };
        DelegatingStreamListener.StreamStateHandler lineStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setPointDelegate(pointLineStart);
            }
        };
        final DelegatingStreamListener.StreamStateHandler lineEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setPointDelegate(point);
            }
        };
        final DelegatingStreamListener.StreamStateHandler lineEndPolygon = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.buffer.push("Z");
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setLineEndDelegate(lineEndPolygon);
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setLineEndDelegate(lineEnd);
                self.setPointDelegate(point);
            }
        };
        this.setPointDelegate(point);
        this.setLineStartDelegate(lineStart);
        this.setLineEndDelegate(lineEnd);
        this.setPolygonStartDelegate(polygonStart);
        this.setPolygonEndDelegate(polygonEnd);
    }

    @Override
    public PathContextStreamListener pointRadius(double r) {
        this.pointCircle = this.pathBufferCircle(r);
        return this;
    }

    @Override
    public Object result() {
        if (this.buffer.length() > 0) {
            String result = this.buffer.join(BLANK);
            this.buffer.clear();
            return result;
        }
        return null;
    }

    private String pathBufferCircle(double radius) {
        double radius2 = radius * 2.0;
        return "m0," + radius + "a" + radius + "," + radius + " 0 1,1 0," + -radius2 + "a" + radius + "," + radius + " 0 1,1 0," + radius2 + "z";
    }

    private static String dblToStr(double d) {
        double dRounded = (double)Math.round(d * 1000.0) / 1000.0;
        return Double.toString(dRounded);
    }
}

