/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.arrays.Merge;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geo.InvertiblePointProjector;
import com.ibm.rave.core.geo.PointProjector;
import com.ibm.rave.core.geo.StreamListener;
import com.ibm.rave.core.internal.geo.ClipBufferStreamListener;
import com.ibm.rave.core.internal.geo.ClipLineStreamListenerFactory;
import com.ibm.rave.core.internal.geo.ClipPolygonIntersection;
import com.ibm.rave.core.internal.geo.ClipUtil;
import com.ibm.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.rave.core.internal.geo.GeoInterpolator;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.util.Comparator;

final class ClipStreamListener
extends DelegatingStreamListener {
    private boolean polygonStarted;
    private ClipUtil.PointVisiblity pointVisible;
    private ClipLineStreamListenerFactory clipLine;
    private GeoInterpolator interpolate;
    private ArrayEx<Double> clipStart;
    private PointProjector rotate;
    private StreamListener listener;
    private Comparator<ClipPolygonIntersection> comparator;
    private ArrayEx<ArrayEx<ArrayEx<ArrayEx<Double>>>> segments;
    private ClipLineStreamListenerFactory.ClipLineStreamListener line;
    private ClipBufferStreamListener bufferListener;
    private ClipLineStreamListenerFactory.ClipLineStreamListener ringListener;
    private ArrayEx<Double> rotatedClipStart;
    private ArrayEx<ArrayEx<ArrayEx<Double>>> polygon;
    private ArrayEx<ArrayEx<Double>> ring;
    private ArrayEx.ArrayValueFunction<ArrayEx<ArrayEx<Double>>, Boolean> clipSegmentLength1;

    ClipStreamListener(ClipUtil.PointVisiblity pointVisible, ClipLineStreamListenerFactory clipLine, GeoInterpolator interpolate, ArrayEx<Double> clipStart, InvertiblePointProjector rotate, StreamListener listener) {
        final ClipStreamListener self = this;
        this.pointVisible = pointVisible;
        this.clipLine = clipLine;
        this.interpolate = interpolate;
        this.clipStart = clipStart;
        this.rotate = rotate;
        this.listener = listener;
        this.line = clipLine.stream(listener);
        this.bufferListener = new ClipBufferStreamListener();
        this.ringListener = clipLine.stream(this.bufferListener);
        this.rotatedClipStart = Lang.toArray(Lang.asDouble(rotate.invert((Double)clipStart.get(0), (Double)clipStart.get(1))));
        this.comparator = new Comparator<ClipPolygonIntersection>(){

            @Override
            public int compare(ClipPolygonIntersection aa, ClipPolygonIntersection bb) {
                ArrayEx<Double> a = aa.getPoint();
                ArrayEx<Double> b = bb.getPoint();
                double result = ((Double)a.get(0) < 0.0 ? (Double)a.get(1) - 1.5707963267948966 - 1.0E-6 : 1.5707963267948966 - (Double)a.get(1)) - ((Double)b.get(0) < 0.0 ? (Double)b.get(1) - 1.5707963267948966 - 1.0E-6 : 1.5707963267948966 - (Double)b.get(1));
                return result == 0.0 ? 0 : (result > 0.0 ? 1 : -1);
            }
        };
        this.clipSegmentLength1 = new ArrayEx.ArrayValueFunction<ArrayEx<ArrayEx<Double>>, Boolean>(){

            @Override
            public Boolean getValue(ArrayEx<ArrayEx<Double>> segment, int index, ArrayEx<ArrayEx<ArrayEx<Double>>> array) {
                return segment.length() > 1;
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler point = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double z) {
                double _\u03bb = \u03bb;
                double _\u03c6 = \u03c6;
                double[] point = self.rotate.project(_\u03bb, _\u03c6);
                _\u03bb = point[0];
                _\u03c6 = point[1];
                if (self.pointVisible.isPointVisible(_\u03bb, _\u03c6, Double.NaN)) {
                    self.listener.point(_\u03bb, _\u03c6, Double.NaN);
                }
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler pointLine = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double z) {
                double[] point = self.rotate.project(\u03bb, \u03c6);
                self.line.point(point[0], point[1], Double.NaN);
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler pointRing = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double z) {
                self.ring.push(new ArrayEx<Object>(\u03bb, \u03c6));
                double[] point = self.rotate.project(\u03bb, \u03c6);
                self.ringListener.point(point[0], point[1], Double.NaN);
            }
        };
        final DelegatingStreamListener.StreamStateHandler lineStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setPointDelegate(pointLine);
                self.line.lineStart();
            }
        };
        final DelegatingStreamListener.StreamStateHandler lineEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setPointDelegate(point);
                self.line.lineEnd();
            }
        };
        final DelegatingStreamListener.StreamStateHandler ringStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.ringListener.lineStart();
                self.ring = new ArrayEx();
            }
        };
        final DelegatingStreamListener.StreamStateHandler ringEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                pointRing.handle((Double)((ArrayEx)self.ring.get(0)).get(0), (Double)((ArrayEx)self.ring.get(0)).get(1), Double.NaN);
                self.ringListener.lineEnd();
                int clean = self.ringListener.clean();
                ArrayEx<ArrayEx<ArrayEx<Double>>> ringSegments = self.bufferListener.buffer();
                int n = ringSegments.length();
                self.ring.pop();
                self.polygon.push(self.ring);
                self.ring = null;
                if (n == 0) {
                    return;
                }
                if ((clean & 1) != 0) {
                    ArrayEx segment = (ArrayEx)ringSegments.get(0);
                    n = segment.length() - 1;
                    int i = -1;
                    if (n > 0) {
                        if (!self.polygonStarted) {
                            self.listener.polygonStart();
                            self.polygonStarted = true;
                        }
                        self.listener.lineStart();
                        while (++i < n) {
                            ArrayEx point = (ArrayEx)segment.get(i);
                            self.listener.point((Double)point.get(0), (Double)point.get(1), Double.NaN);
                        }
                        self.listener.lineEnd();
                    }
                    return;
                }
                if (n > 1 && (clean & 2) != 0) {
                    ringSegments.push(ringSegments.pop().concat(ringSegments.shift()));
                }
                self.segments.push(ringSegments.filter(self.clipSegmentLength1));
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setPointDelegate(pointRing);
                self.setLineStartDelegate(ringStart);
                self.setLineEndDelegate(ringEnd);
                self.segments = new ArrayEx();
                self.polygon = new ArrayEx();
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setPointDelegate(point);
                self.setLineStartDelegate(lineStart);
                self.setLineEndDelegate(lineEnd);
                ArrayEx mergedSegments = (ArrayEx)Merge.merge(self.segments);
                boolean clipStartInside = ClipUtil.pointInPolygon(self.rotatedClipStart, self.polygon);
                if (mergedSegments.length() > 0) {
                    if (!self.polygonStarted) {
                        self.listener.polygonStart();
                        self.polygonStarted = true;
                    }
                    ClipUtil.clipPolygon(mergedSegments, self.comparator, clipStartInside, self.interpolate, self.listener);
                } else if (clipStartInside) {
                    if (!self.polygonStarted) {
                        self.listener.polygonStart();
                        self.polygonStarted = true;
                    }
                    self.listener.lineStart();
                    self.interpolate.interpolate(null, null, 1, self.listener);
                    self.listener.lineEnd();
                }
                if (self.polygonStarted) {
                    self.listener.polygonEnd();
                    self.polygonStarted = false;
                }
                mergedSegments = self.polygon = null;
            }
        };
        DelegatingStreamListener.StreamStateHandler sphere = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.listener.polygonStart();
                self.listener.lineStart();
                self.interpolate.interpolate(null, null, 1, self.listener);
                self.listener.lineEnd();
                self.listener.polygonEnd();
            }
        };
        this.setPointDelegate(point);
        this.setLineStartDelegate(lineStart);
        this.setLineEndDelegate(lineEnd);
        this.setPolygonStartDelegate(polygonStart);
        this.setPolygonEndDelegate(polygonEnd);
        this.setSphereDelegate(sphere);
    }
}

