/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geo.StreamListener;
import com.ibm.rave.core.internal.geo.AntimeridianClipLineStreamListenerFactory;
import com.ibm.rave.core.internal.geo.CartesianUtil;
import com.ibm.rave.core.internal.geo.CircleClipLineStreamListenerFactory;
import com.ibm.rave.core.internal.geo.ClipExtentStreamListenerFactory;
import com.ibm.rave.core.internal.geo.ClipLineStreamListenerFactory;
import com.ibm.rave.core.internal.geo.ClipPolygonIntersection;
import com.ibm.rave.core.internal.geo.ClipStreamListenerFactory;
import com.ibm.rave.core.internal.geo.GeoInterpolator;
import com.ibm.rave.core.internal.geo.GeoShapeGeneratorUtil;
import com.ibm.rave.core.internal.geo.SphericalUtil;
import com.ibm.rave.core.internal.math.Adder;
import com.ibm.rave.core.internal.math.Trigonometry;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.util.Comparator;

public final class ClipUtil {
    private static final PointVisiblity allVisible = new PointVisiblity(){

        @Override
        public boolean isPointVisible(double x, double y, double z) {
            return true;
        }
    };
    private static final GeoInterpolator clipAntimeridianInterpolator = new GeoInterpolator(){

        @Override
        public void interpolate(ArrayEx<Double> from, ArrayEx<Double> to, int direction, StreamListener listener) {
            if (from == null) {
                double \u03c6 = (double)direction * 1.5707963267948966;
                listener.point(-Math.PI, \u03c6, Double.NaN);
                listener.point(0.0, \u03c6, Double.NaN);
                listener.point(Math.PI, \u03c6, Double.NaN);
                listener.point(Math.PI, 0.0, Double.NaN);
                listener.point(Math.PI, -\u03c6, Double.NaN);
                listener.point(0.0, -\u03c6, Double.NaN);
                listener.point(-Math.PI, -\u03c6, Double.NaN);
                listener.point(-Math.PI, 0.0, Double.NaN);
                listener.point(-Math.PI, \u03c6, Double.NaN);
            } else if (Math.abs((Double)from.get(0) - (Double)to.get(0)) > 1.0E-6) {
                double s = (Double)from.get(0) < (Double)to.get(0) ? Math.PI : -Math.PI;
                double \u03c6 = (double)direction * s / 2.0;
                listener.point(-s, \u03c6, Double.NaN);
                listener.point(0.0, \u03c6, Double.NaN);
                listener.point(s, \u03c6, Double.NaN);
            } else {
                listener.point((Double)to.get(0), (Double)to.get(1), Double.NaN);
            }
        }
    };

    public static ClipExtentStreamListenerFactory newClipExtentStreamListenerFactory(double x0, double y0, double x1, double y1) {
        return new ClipExtentStreamListenerFactory(x0, y0, x1, y1);
    }

    static ClipStreamListenerFactory newClipStreamListenerFactory(PointVisiblity pointVisible, ClipLineStreamListenerFactory clipLine, GeoInterpolator interpolate, ArrayEx<Double> clipStart) {
        return new ClipStreamListenerFactory(pointVisible, clipLine, interpolate, clipStart);
    }

    static ClipStreamListenerFactory newClipCircleStreamListenerFactory(double radius) {
        CircleClipLineStreamListenerFactory circleClipLine = new CircleClipLineStreamListenerFactory(radius);
        GeoInterpolator interpolator = GeoShapeGeneratorUtil.newCircleInterpolator(radius, 0.10471975511965978);
        return new ClipStreamListenerFactory(circleClipLine.getPointVisiblilty(), circleClipLine, interpolator, circleClipLine.isSmallRadius() ? new ArrayEx<Double>(0.0, -radius) : new ArrayEx<Double>(-Math.PI, radius - Math.PI));
    }

    static ClipStreamListenerFactory newAntimeridianClipLineStreamListenerFactory() {
        AntimeridianClipLineStreamListenerFactory antimeridianClipLine = new AntimeridianClipLineStreamListenerFactory();
        return new ClipStreamListenerFactory(allVisible, antimeridianClipLine, clipAntimeridianInterpolator, new ArrayEx<Double>(-Math.PI, -1.5707963267948966));
    }

    static void clipPolygon(ArrayEx<ArrayEx<ArrayEx<Double>>> segments, Comparator<ClipPolygonIntersection> comparator, boolean clipStartInside, GeoInterpolator interpolator, final StreamListener listener) {
        final ArrayEx<ClipPolygonIntersection> subject = new ArrayEx<ClipPolygonIntersection>();
        final ArrayEx<ClipPolygonIntersection> clip = new ArrayEx<ClipPolygonIntersection>();
        segments.forEach(new ArrayEx.ArrayValueFunction<ArrayEx<ArrayEx<Double>>, Object>(){

            @Override
            public Object getValue(ArrayEx<ArrayEx<Double>> segment, int index, ArrayEx<ArrayEx<ArrayEx<Double>>> array) {
                int n = segment.length() - 1;
                if (n <= 0) {
                    return null;
                }
                ArrayEx p0 = (ArrayEx)segment.get(0);
                ArrayEx p1 = (ArrayEx)segment.get(n);
                if (SphericalUtil.sphericalEqual(Lang.asPrimitiveDouble(p0), Lang.asPrimitiveDouble(p1))) {
                    listener.lineStart();
                    for (int i = 0; i < n; ++i) {
                        p0 = (ArrayEx)segment.get(i);
                        listener.point((Double)p0.get(0), (Double)p0.get(1), Double.NaN);
                    }
                    listener.lineEnd();
                    return null;
                }
                ClipPolygonIntersection a = new ClipPolygonIntersection(p0, segment, null, true);
                ClipPolygonIntersection b = new ClipPolygonIntersection(p0, null, a, false);
                a.setOtherIntersection(b);
                subject.push(a);
                clip.push(b);
                a = new ClipPolygonIntersection(p1, segment, null, false);
                b = new ClipPolygonIntersection(p1, null, a, true);
                a.setOtherIntersection(b);
                subject.push(a);
                clip.push(b);
                return null;
            }
        });
        clip.sort(comparator);
        ClipUtil.clipPolygonLinkCircular(subject);
        ClipUtil.clipPolygonLinkCircular(clip);
        if (subject.length() == 0) {
            return;
        }
        boolean entry = clipStartInside;
        int n = clip.length();
        for (int i = 0; i < n; ++i) {
            entry = !entry;
            ((ClipPolygonIntersection)clip.get(i)).setEntry(entry);
        }
        ClipPolygonIntersection start = (ClipPolygonIntersection)subject.get(0);
        while (true) {
            ClipPolygonIntersection current = start;
            boolean isSubject = true;
            while (current.isVisited()) {
                if ((current = current.getNext()) != start) continue;
                return;
            }
            ArrayEx<ArrayEx<Double>> points = current.getPoints();
            listener.lineStart();
            do {
                ArrayEx point;
                int i;
                current.setVisited(true);
                current.getOtherIntersection().setVisited(true);
                if (current.isEntry()) {
                    if (isSubject) {
                        int n2 = points.length();
                        for (i = 0; i < n2; ++i) {
                            point = (ArrayEx)points.get(i);
                            listener.point((Double)point.get(0), (Double)point.get(1), Double.NaN);
                        }
                    } else {
                        interpolator.interpolate(current.getPoint(), current.getNext().getPoint(), 1, listener);
                    }
                    current = current.getNext();
                } else {
                    if (isSubject) {
                        points = current.getPrevious().getPoints();
                        for (i = points.length() - 1; i >= 0; --i) {
                            point = (ArrayEx)points.get(i);
                            listener.point((Double)point.get(0), (Double)point.get(1), Double.NaN);
                        }
                    } else {
                        interpolator.interpolate(current.getPoint(), current.getPrevious().getPoint(), -1, listener);
                    }
                    current = current.getPrevious();
                }
                current = current.getOtherIntersection();
                points = current.getPoints();
                boolean bl = isSubject = !isSubject;
            } while (!current.isVisited());
            listener.lineEnd();
        }
    }

    static void clipPolygonLinkCircular(ArrayEx<ClipPolygonIntersection> array) {
        ClipPolygonIntersection b;
        int n = array.length();
        if (n == 0) {
            return;
        }
        int i = 0;
        ClipPolygonIntersection a = (ClipPolygonIntersection)array.get(0);
        while (++i < n) {
            b = (ClipPolygonIntersection)array.get(i);
            a.setNext(b);
            b.setPrevious(a);
            a = b;
        }
        b = (ClipPolygonIntersection)array.get(0);
        a.setNext(b);
        b.setPrevious(a);
    }

    public static boolean pointInPolygon(ArrayEx<Double> point, ArrayEx<ArrayEx<ArrayEx<Double>>> polygon) {
        ArrayEx _point = point;
        double polarAngle = 0.0;
        double meridian = (Double)_point.get(0);
        double parallel = (Double)_point.get(1);
        int winding = 0;
        double[] meridianNormal = new double[]{Math.sin(meridian), -Math.cos(meridian), 0.0};
        Adder areaRingSum = new Adder();
        int n = polygon.length();
        block0: for (int i = 0; i < n; ++i) {
            ArrayEx ring = (ArrayEx)polygon.get(i);
            int m = ring.length();
            if (m == 0) continue;
            ArrayEx point0 = (ArrayEx)ring.get(0);
            double \u03bb0 = (Double)point0.get(0);
            double \u03c60 = (Double)point0.get(1) / 2.0 + 0.7853981633974483;
            double sin\u03c60 = Math.sin(\u03c60);
            double cos\u03c60 = Math.cos(\u03c60);
            int j = 1;
            while (true) {
                if (j == m) {
                    j = 0;
                }
                _point = (ArrayEx)ring.get(j);
                double \u03bb = (Double)_point.get(0);
                double \u03c6 = (Double)_point.get(1) / 2.0 + 0.7853981633974483;
                double sin\u03c6 = Math.sin(\u03c6);
                double cos\u03c6 = Math.cos(\u03c6);
                double d\u03bb = \u03bb - \u03bb0;
                double sd\u03bb = d\u03bb >= 0.0 ? 1.0 : -1.0;
                double ad\u03bb = sd\u03bb * d\u03bb;
                double k = sin\u03c60 * sin\u03c6;
                boolean antimeridian = ad\u03bb > Math.PI;
                areaRingSum.add(Math.atan2(k * sd\u03bb * Math.sin(ad\u03bb), cos\u03c60 * cos\u03c6 + k * Math.cos(ad\u03bb)));
                polarAngle += antimeridian ? d\u03bb + sd\u03bb * (Math.PI * 2) : d\u03bb;
                if (antimeridian ^ \u03bb0 >= meridian ^ \u03bb >= meridian) {
                    double[] arc = CartesianUtil.cartesianCross(CartesianUtil.cartesian(Lang.asPrimitiveDouble(point0)), CartesianUtil.cartesian(Lang.asPrimitiveDouble(_point)));
                    CartesianUtil.cartesianNormalize(arc);
                    double[] intersection = CartesianUtil.cartesianCross(meridianNormal, arc);
                    CartesianUtil.cartesianNormalize(intersection);
                    double \u03c6arc = (double)(antimeridian ^ d\u03bb >= 0.0 ? -1 : 1) * Trigonometry.asin(intersection[2]);
                    if (parallel > \u03c6arc || parallel == \u03c6arc && (arc[0] != 0.0 || arc[1] != 0.0)) {
                        winding += antimeridian ^ d\u03bb >= 0.0 ? 1 : -1;
                    }
                }
                if (j++ == 0) continue block0;
                \u03bb0 = \u03bb;
                sin\u03c60 = sin\u03c6;
                cos\u03c60 = cos\u03c6;
                point0 = _point;
            }
        }
        return (polarAngle < -1.0E-6 || polarAngle < 1.0E-6 && areaRingSum.valueOf() < 0.0) ^ winding & true;
    }

    @FunctionClass(value="isPointVisible")
    @SwiftClosure(value="isPointVisible")
    public static interface PointVisiblity {
        public boolean isPointVisible(double var1, double var3, double var5);
    }
}

