/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.geo.ConicProjection;
import com.ibm.rave.core.geo.ConicProjectionFactory;
import com.ibm.rave.core.geo.InvertiblePointProjector;
import com.ibm.rave.core.geo.PointProjector;
import com.ibm.rave.core.geo.PointProjectorFactory;
import com.ibm.rave.core.internal.geo.ConicProjectionImpl;
import com.ibm.rave.core.internal.geo.MercatorPlaneProjectionFactory;
import com.ibm.rave.core.internal.math.Trigonometry;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;

public final class ConicProjectionFactoryImpl
implements ConicProjectionFactory {
    private final PointProjectorFactory raw;

    private ConicProjectionFactoryImpl(PointProjectorFactory factory) {
        this.raw = factory;
    }

    @Override
    public final ConicProjection create() {
        return new ConicProjectionImpl(this.raw);
    }

    @Override
    public final PointProjectorFactory getRaw() {
        return this.raw;
    }

    public static ConicProjectionFactory newConicEqualAreaProjectionFactory() {
        PointProjectorFactory factory = new PointProjectorFactory(){

            @Override
            public PointProjector create(Object ... args) {
                double \u03c60 = ObjectConverter.asDouble(args[0]);
                double \u03c61 = ObjectConverter.asDouble(args[1]);
                double sin\u03c60 = Math.sin(\u03c60);
                final double n = (sin\u03c60 + Math.sin(\u03c61)) / 2.0;
                final double C = 1.0 + sin\u03c60 * (2.0 * n - sin\u03c60);
                final double \u03c10 = Math.sqrt(C) / n;
                return new InvertiblePointProjector(){

                    @Override
                    public boolean supportInversion() {
                        return true;
                    }

                    @Override
                    public double[] project(double \u03bb, double \u03c6) {
                        double _\u03bb = \u03bb;
                        double \u03c1 = Math.sqrt(C - 2.0 * n * Math.sin(\u03c6)) / n;
                        return new double[]{\u03c1 * Math.sin(_\u03bb *= n), \u03c10 - \u03c1 * Math.cos(_\u03bb)};
                    }

                    @Override
                    public double[] invert(double x, double y) {
                        double \u03c10_y = \u03c10 - y;
                        return new double[]{Math.atan2(x, \u03c10_y) / n, Trigonometry.asin((C - (x * x + \u03c10_y * \u03c10_y) * n * n) / (2.0 * n))};
                    }
                };
            }
        };
        return new ConicProjectionFactoryImpl(factory);
    }

    public static ConicProjectionFactory newConicEquidistantProjectionFactory() {
        PointProjectorFactory factory = new PointProjectorFactory(){

            @Override
            public PointProjector create(Object ... args) {
                double \u03c60 = ObjectConverter.toDouble(args[0]);
                double \u03c61 = ObjectConverter.toDouble(args[1]);
                double cos\u03c60 = Math.cos(\u03c60);
                final double n = \u03c60 == \u03c61 ? Math.sin(\u03c60) : (cos\u03c60 - Math.cos(\u03c61)) / (\u03c61 - \u03c60);
                final double G = cos\u03c60 / n + \u03c60;
                if (Math.abs(n) < 1.0E-6) {
                    return new InvertiblePointProjector(){

                        @Override
                        public boolean supportInversion() {
                            return true;
                        }

                        @Override
                        public double[] project(double \u03bb, double \u03c6) {
                            return new double[]{\u03bb, \u03c6};
                        }

                        @Override
                        public double[] invert(double x, double y) {
                            return new double[]{x, y};
                        }
                    };
                }
                return new InvertiblePointProjector(){

                    @Override
                    public boolean supportInversion() {
                        return true;
                    }

                    @Override
                    public double[] project(double \u03bb, double \u03c6) {
                        double \u03c1 = G - \u03c6;
                        return new double[]{\u03c1 * Math.sin(n * \u03bb), G - \u03c1 * Math.cos(n * \u03bb)};
                    }

                    @Override
                    public double[] invert(double x, double y) {
                        double \u03c10_y = G - y;
                        return new double[]{Math.atan2(x, \u03c10_y) / n, G - (double)Trigonometry.sgn(n) * Math.sqrt(x * x + \u03c10_y * \u03c10_y)};
                    }
                };
            }
        };
        return new ConicProjectionFactoryImpl(factory);
    }

    public static ConicProjectionFactory newConicConformalProjectionFactory() {
        PointProjectorFactory factory = new PointProjectorFactory(){

            @Override
            public PointProjector create(Object ... args) {
                double \u03c60 = ObjectConverter.toDouble(args[0]);
                double \u03c61 = ObjectConverter.toDouble(args[1]);
                double cos\u03c60 = Math.cos(\u03c60);
                final double n = \u03c60 == \u03c61 ? Math.sin(\u03c60) : Math.log(cos\u03c60 / Math.cos(\u03c61)) / Math.log(Math.tan(0.7853981633974483 + \u03c61 / 2.0) / Math.tan(0.7853981633974483 + \u03c60 / 2.0));
                final double F = cos\u03c60 * Math.pow(Math.tan(0.7853981633974483 + \u03c60 / 2.0), n) / n;
                if (!ObjectConverter.toBoolean(n)) {
                    return MercatorPlaneProjectionFactory.INSTANCE.getRaw();
                }
                return new InvertiblePointProjector(){

                    @Override
                    public boolean supportInversion() {
                        return true;
                    }

                    @Override
                    public double[] project(double \u03bb, double \u03c6) {
                        double _\u03c6 = \u03c6;
                        if (F > 0.0) {
                            if (_\u03c6 < -1.5707953267948966) {
                                _\u03c6 = -1.5707953267948966;
                            }
                        } else if (_\u03c6 > 1.5707953267948966) {
                            _\u03c6 = 1.5707953267948966;
                        }
                        double \u03c1 = F / Math.pow(Math.tan(0.7853981633974483 + _\u03c6 / 2.0), n);
                        return new double[]{\u03c1 * Math.sin(n * \u03bb), F - \u03c1 * Math.cos(n * \u03bb)};
                    }

                    @Override
                    public double[] invert(double x, double y) {
                        double \u03c10_y = F - y;
                        double \u03c1 = (double)Trigonometry.sgn(n) * Math.sqrt(x * x + \u03c10_y * \u03c10_y);
                        return new double[]{Math.atan2(x, \u03c10_y) / n, 2.0 * Math.atan(Math.pow(F / \u03c1, 1.0 / n)) - 1.5707963267948966};
                    }
                };
            }
        };
        return new ConicProjectionFactoryImpl(factory);
    }
}

