/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.geo.DrawingContext;
import com.ibm.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.rave.core.internal.geo.PathContextStreamListener;

class DrawingPathContextStreamListener
extends DelegatingStreamListener
implements PathContextStreamListener {
    private double pointRadiusValue = 4.5;
    private final DrawingContext context;

    DrawingPathContextStreamListener(DrawingContext context) {
        this.context = context;
        final DrawingPathContextStreamListener self = this;
        final DelegatingStreamListener.StreamPointStateHandler point = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                self.context.moveTo(x + self.pointRadiusValue, y);
                self.context.arc(x, y, self.pointRadiusValue, 0.0, Math.PI * 2);
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler pointLine = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                self.context.lineTo(x, y);
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler pointLineStart = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                self.context.moveTo(x, y);
                self.setPointDelegate(pointLine);
            }
        };
        DelegatingStreamListener.StreamStateHandler lineStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setPointDelegate(pointLineStart);
            }
        };
        final DelegatingStreamListener.StreamStateHandler lineEndPolygon = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.context.closePath();
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setLineEndDelegate(lineEndPolygon);
            }
        };
        final DelegatingStreamListener.StreamStateHandler lineEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setPointDelegate(point);
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setLineEndDelegate(lineEnd);
                self.setPointDelegate(point);
            }
        };
        this.setPointDelegate(point);
        this.setLineStartDelegate(lineStart);
        this.setLineEndDelegate(lineEnd);
        this.setPolygonStartDelegate(polygonStart);
        this.setPolygonEndDelegate(polygonEnd);
    }

    @Override
    public PathContextStreamListener pointRadius(double r) {
        this.pointRadiusValue = r;
        return this;
    }

    @Override
    public Object result() {
        return this.context;
    }
}

