/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geo.BasicProjection;
import com.ibm.rave.core.geo.DrawingContext;
import com.ibm.rave.core.geo.GeoPathGenerator;
import com.ibm.rave.core.geo.StreamListener;
import com.ibm.rave.core.geo.StreamingBasicProjection;
import com.ibm.rave.core.geom.Path2DHandler;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.geo.AlbersUsaProjection;
import com.ibm.rave.core.internal.geo.BufferPathContextStreamListener;
import com.ibm.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.rave.core.internal.geo.DrawingPathContextStreamListener;
import com.ibm.rave.core.internal.geo.PathActionDrawingContext;
import com.ibm.rave.core.internal.geo.PathAreaStreamListener;
import com.ibm.rave.core.internal.geo.PathBoundsStreamListener;
import com.ibm.rave.core.internal.geo.PathCentroidStreamListener;
import com.ibm.rave.core.internal.geo.PathContextStreamListener;
import com.ibm.rave.core.internal.geo.ProjectionImpl;
import com.ibm.rave.core.internal.geo.ResamplePointProjector;
import com.ibm.rave.core.internal.geo.ResampleStreamListenerFactory;
import com.ibm.rave.core.internal.geo.Stream;
import com.ibm.rave.core.internal.geo.TransformStreamListenerImpl;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.ISceneNode;

public class GeoPathGeneratorImpl
implements GeoPathGenerator {
    private Object pointRadiusValue = 4.5;
    private BasicProjection basicProjection;
    private DrawingContext drawingContext;
    private ProjectStream projectStream;
    private PathContextStreamListener contextStream;
    private DelegatingStreamListener cacheStream;
    private PathCentroidStreamListener pathCentroid;
    private PathAreaStreamListener pathArea;
    private PathBoundsStreamListener pathBounds;

    private GeoPathGeneratorImpl() {
    }

    @Override
    public Object getValue(Object context, Object data, int index, int groupIndex) {
        JSONObject object;
        if (!(data instanceof JSONObject)) {
            return null;
        }
        DrawingContext origContext = this.context();
        if (context instanceof ISceneNode) {
            this.context(new PathActionDrawingContext());
        }
        if ((object = (JSONObject)data) != null) {
            if (this.cacheStream == null || !this.cacheStream.isValid()) {
                if (this.pointRadiusValue instanceof GeoPathGenerator.PointRadiusValueFunction) {
                    this.contextStream.pointRadius(ObjectConverter.toDouble(((GeoPathGenerator.PointRadiusValueFunction)this.pointRadiusValue).getValue(object, index)));
                } else {
                    this.contextStream.pointRadius(ObjectConverter.toDouble(this.pointRadiusValue));
                }
                this.cacheStream = this.projectStream.stream(this.contextStream);
            }
            Stream.INSTANCE.stream(object, this.cacheStream);
        }
        Object result = this.contextStream.result();
        this.context(origContext);
        return result;
    }

    @Override
    public DrawingContext context() {
        return this.drawingContext;
    }

    @Override
    public GeoPathGenerator context(DrawingContext context) {
        this.drawingContext = context;
        this.contextStream = context == null ? new BufferPathContextStreamListener() : new DrawingPathContextStreamListener(context);
        this.reset();
        return this;
    }

    @Override
    public double area(JSONObject object) {
        this.pathArea = new PathAreaStreamListener();
        Stream.INSTANCE.stream(object, this.projectStream.stream(this.pathArea));
        return this.pathArea.getPathAreaSum();
    }

    @Override
    public double[] centroid(JSONObject object) {
        double[] dArray;
        this.pathCentroid = new PathCentroidStreamListener();
        Stream.INSTANCE.stream(object, this.projectStream.stream(this.pathCentroid));
        if (ObjectConverter.toBoolean(this.pathCentroid.getCentroidZ2())) {
            double[] dArray2 = new double[2];
            dArray2[0] = this.pathCentroid.getCentroidX2() / this.pathCentroid.getCentroidZ2();
            dArray = dArray2;
            dArray2[1] = this.pathCentroid.getCentroidY2() / this.pathCentroid.getCentroidZ2();
        } else if (ObjectConverter.toBoolean(this.pathCentroid.getCentroidZ1())) {
            double[] dArray3 = new double[2];
            dArray3[0] = this.pathCentroid.getCentroidX1() / this.pathCentroid.getCentroidZ1();
            dArray = dArray3;
            dArray3[1] = this.pathCentroid.getCentroidY1() / this.pathCentroid.getCentroidZ1();
        } else if (ObjectConverter.toBoolean(this.pathCentroid.getCentroidZ0())) {
            double[] dArray4 = new double[2];
            dArray4[0] = this.pathCentroid.getCentroidX0() / this.pathCentroid.getCentroidZ0();
            dArray = dArray4;
            dArray4[1] = this.pathCentroid.getCentroidY0() / this.pathCentroid.getCentroidZ0();
        } else {
            double[] dArray5 = new double[2];
            dArray5[0] = Double.NaN;
            dArray = dArray5;
            dArray5[1] = Double.NaN;
        }
        return dArray;
    }

    @Override
    public double[][] bounds(JSONObject object) {
        this.pathBounds = new PathBoundsStreamListener();
        Stream.INSTANCE.stream(object, this.projectStream.stream(this.pathBounds));
        return new double[][]{{this.pathBounds.getPathBoundsX0(), this.pathBounds.getPathBoundsY0()}, {this.pathBounds.getPathBoundsX1(), this.pathBounds.getPathBoundsY1()}};
    }

    @Override
    public BasicProjection projection() {
        return this.basicProjection;
    }

    @Override
    public GeoPathGenerator projection(BasicProjection projection) {
        this.basicProjection = projection;
        if (this.basicProjection != null) {
            if (this.basicProjection.supportStreaming()) {
                final GeoPathGeneratorImpl self = this;
                this.projectStream = new ProjectStream(){

                    @Override
                    public DelegatingStreamListener stream(StreamListener listener) {
                        return ((StreamingBasicProjection)self.basicProjection).stream(listener);
                    }
                };
            } else {
                this.projectStream = this.pathProjectStream(projection);
            }
        } else {
            this.projectStream = new ProjectStream(){

                @Override
                public DelegatingStreamListener stream(StreamListener listener) {
                    return new TransformStreamListenerImpl(listener, new OMap<String, DelegatingStreamListener.BaseStreamStateHandler>());
                }
            };
        }
        return this.reset();
    }

    @Override
    public Object pointRadius() {
        return this.pointRadiusValue;
    }

    @Override
    public GeoPathGenerator pointRadius(Object value) {
        this.pointRadiusValue = value instanceof GeoPathGenerator.PointRadiusValueFunction ? value : Double.valueOf(ObjectConverter.toDouble(value));
        this.reset();
        return this;
    }

    private GeoPathGenerator reset() {
        this.cacheStream = null;
        return this;
    }

    public static GeoPathGenerator newGeoPathGenerator() {
        GeoPathGeneratorImpl path = new GeoPathGeneratorImpl();
        path.projection(AlbersUsaProjection.newAlbersUsaProjection()).context(null);
        return path;
    }

    private ProjectStream pathProjectStream(final BasicProjection projection) {
        final ResampleStreamListenerFactory resampleFactory = new ResampleStreamListenerFactory(new ResamplePointProjector(){

            @Override
            public double[] project(double x, double y, double z) {
                return Lang.asPrimitiveDouble(projection.project(new ArrayEx<Double>(x * 57.29577951308232, y * 57.29577951308232)));
            }
        });
        return new ProjectStream(){

            @Override
            public DelegatingStreamListener stream(StreamListener listener) {
                return ProjectionImpl.projectionRadians(resampleFactory.resample(listener));
            }
        };
    }

    @Override
    public void draw(Path2DHandler path2dHandler) {
    }

    @FunctionClass(value="stream")
    @SwiftClosure(value="stream")
    private static interface ProjectStream {
        public DelegatingStreamListener stream(StreamListener var1);
    }
}

