/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geo.StreamListener;
import com.ibm.rave.core.internal.geo.CartesianUtil;
import com.ibm.rave.core.internal.geo.GeoInterpolator;
import com.ibm.rave.core.internal.geo.SphericalUtil;
import com.ibm.rave.core.internal.math.Trigonometry;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;

public class GeoShapeGeneratorUtil {
    public static GeoInterpolator newCircleInterpolator(final double radius, final double precision) {
        final double cr = Math.cos(radius);
        final double sr = Math.sin(radius);
        return new GeoInterpolator(){

            @Override
            public void interpolate(ArrayEx<Double> from, ArrayEx<Double> to, int direction, StreamListener listener) {
                double toAngle;
                double fromAngle;
                double step = (double)direction * precision;
                if (from != null) {
                    fromAngle = GeoShapeGeneratorUtil.circleAngle(cr, from);
                    toAngle = GeoShapeGeneratorUtil.circleAngle(cr, to);
                    if (direction > 0 ? fromAngle < toAngle : fromAngle > toAngle) {
                        fromAngle += (double)direction * (Math.PI * 2);
                    }
                } else {
                    fromAngle = radius + (double)direction * (Math.PI * 2);
                    toAngle = radius - 0.5 * step;
                }
                double t = fromAngle;
                while (direction > 0 ? t > toAngle : t < toAngle) {
                    double[] point = SphericalUtil.spherical(new double[]{cr, -sr * Math.cos(t), -sr * Math.sin(t)});
                    listener.point(point[0], point[1], Double.NaN);
                    t -= step;
                }
            }
        };
    }

    static double circleAngle(double cr, ArrayEx<Double> sphericalPoint) {
        double[] a = CartesianUtil.cartesian(Lang.asPrimitiveDouble(sphericalPoint));
        a[0] = a[0] - cr;
        CartesianUtil.cartesianNormalize(a);
        double angle = Trigonometry.acos(-a[1]);
        return ((-a[2] < 0.0 ? -angle : angle) + Math.PI * 2 - 1.0E-6) % (Math.PI * 2);
    }

    public static GraticuleValueFunction graticuleX(double y0, double y1, double dy) {
        final ArrayEx<Number> array = Rave.range(y0, y1 - 1.0E-6, dy).concat(y1);
        return new GraticuleValueFunction(){

            @Override
            public ArrayEx<ArrayEx<Number>> getValue(final Number x) {
                return array.map(new ArrayEx.ArrayValueFunction<Number, ArrayEx<Number>>(){

                    @Override
                    public ArrayEx<Number> getValue(Number currentValue, int index, ArrayEx<Number> arr) {
                        return new ArrayEx<Number>(x, ObjectConverter.toDouble(currentValue));
                    }
                });
            }
        };
    }

    public static GraticuleValueFunction graticuleY(double x0, double x1, double dx) {
        final ArrayEx<Number> array = Rave.range(x0, x1 - 1.0E-6, dx).concat(x1);
        return new GraticuleValueFunction(){

            @Override
            public ArrayEx<ArrayEx<Number>> getValue(final Number y) {
                return array.map(new ArrayEx.ArrayValueFunction<Number, ArrayEx<Number>>(){

                    @Override
                    public ArrayEx<Number> getValue(Number currentValue, int index, ArrayEx<Number> arr) {
                        return new ArrayEx<Number>(ObjectConverter.toDouble(currentValue), y);
                    }
                });
            }
        };
    }

    @FunctionClass(value="getValue")
    @SwiftClosure(value="getValue")
    public static interface GraticuleValueFunction {
        public ArrayEx<ArrayEx<Number>> getValue(Number var1);
    }
}

