/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.geo.InvertiblePointProjector;
import com.ibm.rave.core.geo.InvertibleProjection;
import com.ibm.rave.core.geo.PlaneProjectionFactory;
import com.ibm.rave.core.geo.PointProjector;
import com.ibm.rave.core.internal.geo.MercatorProjection;
import com.ibm.rave.core.internal.geo.ProjectionMutatorImpl;

public final class MercatorPlaneProjectionFactory
implements PlaneProjectionFactory {
    public static final MercatorPlaneProjectionFactory INSTANCE = new MercatorPlaneProjectionFactory();
    private final PointProjector raw = new InvertiblePointProjector(){

        @Override
        public boolean supportInversion() {
            return true;
        }

        @Override
        public double[] project(double \u03bb, double \u03c6) {
            return new double[]{\u03bb, Math.log(Math.tan(0.7853981633974483 + \u03c6 / 2.0))};
        }

        @Override
        public double[] invert(double x, double y) {
            return new double[]{x, 2.0 * Math.atan(Math.exp(y)) - 1.5707963267948966};
        }
    };

    private MercatorPlaneProjectionFactory() {
    }

    @Override
    public InvertibleProjection create() {
        MercatorProjection m = new MercatorProjection();
        ProjectionMutatorImpl.internalMutate(m, this.raw);
        m.init();
        return m;
    }

    @Override
    public final PointProjector getRaw() {
        return this.raw;
    }
}

