/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geo.Projection;
import com.ibm.rave.core.internal.geo.InvertibleProjectionImpl;

class MercatorProjection
extends InvertibleProjectionImpl {
    protected boolean clipAuto;

    protected MercatorProjection() {
    }

    protected void init() {
        this.clipExtent(null);
    }

    @Override
    public Projection scale(Object scale) {
        super.scale(scale);
        if (this.clipAuto) {
            return this.clipExtent(null);
        }
        return this;
    }

    public Projection translate(ArrayEx<?> translate) {
        super.translate(translate);
        if (this.clipAuto) {
            return this.clipExtent(null);
        }
        return this;
    }

    @Override
    public Projection clipExtent(ArrayEx<ArrayEx<Double>> clipExtent) {
        super.clipExtent(clipExtent);
        this.clipAuto = clipExtent == null;
        if (this.clipAuto) {
            double k = Math.PI * super.scale();
            ArrayEx<Double> t = super.translate();
            super.clipExtent(new ArrayEx<ArrayEx<Double>>(new ArrayEx<Double>((Double)t.get(0) - k, (Double)t.get(1) - k), new ArrayEx<Double>((Double)t.get(0) + k, (Double)t.get(1) + k)));
        }
        return this;
    }

    @Override
    public ArrayEx<ArrayEx<Double>> clipExtent() {
        if (this.clipAuto) {
            return null;
        }
        return super.clipExtent();
    }
}

