/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.geo.DrawingContext;
import java.util.ArrayList;
import java.util.List;

public class PathActionDrawingContext
implements DrawingContext {
    List<PathAction> actions = new ArrayList<PathAction>();

    @Override
    public void beginPath() {
    }

    @Override
    public void moveTo(double x, double y) {
        this.actions.add(new MovePathAction(x, y));
    }

    @Override
    public void lineTo(double x, double y) {
        this.actions.add(new LinePathAction(x, y));
    }

    @Override
    public void arc(double x, double y, double radius, double startAngle, double endAngle) {
        this.actions.add(new ArcPathAction(x, y, radius, startAngle, endAngle));
    }

    @Override
    public void closePath() {
    }

    class ArcPathAction
    extends PathAction {
        final double radius;
        final double startAngle;
        final double endAngle;

        public ArcPathAction(double x, double y, double radius, double startAngle, double endAngle) {
            super(x, y);
            this.radius = radius;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
        }

        @Override
        int type() {
            return 3;
        }
    }

    class LinePathAction
    extends PathAction {
        LinePathAction(double x, double y) {
            super(x, y);
        }

        @Override
        int type() {
            return 2;
        }
    }

    class MovePathAction
    extends PathAction {
        MovePathAction(double x, double y) {
            super(x, y);
        }

        @Override
        int type() {
            return 1;
        }
    }

    public abstract class PathAction {
        public static final int MOVE = 1;
        public static final int LINE = 2;
        public static final int ARC = 3;
        public final double x;
        public final double y;

        abstract int type();

        PathAction(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

