/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.internal.geo.DelegatingStreamListener;

final class PathAreaStreamListener
extends DelegatingStreamListener {
    private double pathAreaSum;
    private double pathAreaPolygon;
    private double ringStart_x00;
    private double ringStart_y00;
    private double ringStart_x0;
    private double ringStart_y0;

    final double getPathAreaSum() {
        return this.pathAreaSum;
    }

    PathAreaStreamListener() {
        final PathAreaStreamListener self = this;
        final DelegatingStreamListener.StreamPointStateHandler pathAreaRingStart_nextPoint = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double zz) {
                self.pathAreaPolygon = self.pathAreaPolygon + (self.ringStart_y0 * x - self.ringStart_x0 * y);
                self.ringStart_x0 = x;
                self.ringStart_y0 = y;
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler pathAreaRingStart_point = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                self.setPointDelegate(pathAreaRingStart_nextPoint);
                self.ringStart_x00 = (self.ringStart_x0 = x);
                self.ringStart_y00 = (self.ringStart_y0 = y);
            }
        };
        final DelegatingStreamListener.StreamStateHandler pathAreaRingStart_lineEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                pathAreaRingStart_nextPoint.handle(self.ringStart_x00, self.ringStart_y00, Double.NaN);
            }
        };
        final DelegatingStreamListener.StreamStateHandler pathAreaRingStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.ringStart_x00 = (self.ringStart_y00 = (self.ringStart_x0 = (self.ringStart_y0 = 0.0)));
                self.setPointDelegate(pathAreaRingStart_point);
                self.setLineEndDelegate(pathAreaRingStart_lineEnd);
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.pathAreaPolygon = 0.0;
                self.setLineStartDelegate(pathAreaRingStart);
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setPointDelegate(null);
                self.setLineStartDelegate(null);
                self.setLineEndDelegate(null);
                self.pathAreaSum = self.pathAreaSum + Math.abs(self.pathAreaPolygon / 2.0);
            }
        };
        this.setPolygonStartDelegate(polygonStart);
        this.setPolygonEndDelegate(polygonEnd);
    }
}

