/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.internal.geo.DelegatingStreamListener;

final class PathCentroidStreamListener
extends DelegatingStreamListener {
    private double centroidX0;
    private double centroidY0;
    private double centroidZ0;
    private double centroidX1;
    private double centroidY1;
    private double centroidZ1;
    private double centroidX2;
    private double centroidY2;
    private double centroidZ2;
    private double lineStart_x0;
    private double lineStart_y0;
    private double ringStart_x00;
    private double ringStart_y00;
    private double ringStart_x0;
    private double ringStart_y0;

    PathCentroidStreamListener() {
        final PathCentroidStreamListener self = this;
        final DelegatingStreamListener.StreamPointStateHandler centroidPoint = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                self.centroidX0 = self.centroidX0 + x;
                self.centroidY0 = self.centroidY0 + y;
                self.centroidZ0 += 1.0;
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler centroidLineStart_nextPoint = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double zz) {
                double dx = x - self.lineStart_x0;
                double dy = y - self.lineStart_y0;
                double z = Math.sqrt(dx * dx + dy * dy);
                self.centroidX1 = self.centroidX1 + z * (self.lineStart_x0 + x) / 2.0;
                self.centroidY1 = self.centroidY1 + z * (self.lineStart_y0 + y) / 2.0;
                self.centroidZ1 = self.centroidZ1 + z;
                centroidPoint.handle(self.lineStart_x0 = x, self.lineStart_y0 = y, Double.NaN);
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler centroidLineStart_point = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                self.setPointDelegate(centroidLineStart_nextPoint);
                centroidPoint.handle(self.lineStart_x0 = x, self.lineStart_y0 = y, Double.NaN);
            }
        };
        final DelegatingStreamListener.StreamStateHandler centroidLineStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.lineStart_x0 = (self.lineStart_y0 = 0.0);
                self.setPointDelegate(centroidLineStart_point);
            }
        };
        final DelegatingStreamListener.StreamStateHandler centroidLineEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setPointDelegate(centroidPoint);
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler centroidRingStart_nextPoint = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double zz) {
                double dx = x - self.ringStart_x0;
                double dy = y - self.ringStart_y0;
                double z = Math.sqrt(dx * dx + dy * dy);
                self.centroidX1 = self.centroidX1 + z * (self.ringStart_x0 + x) / 2.0;
                self.centroidY1 = self.centroidY1 + z * (self.ringStart_y0 + y) / 2.0;
                self.centroidZ1 = self.centroidZ1 + z;
                z = self.ringStart_y0 * x - self.ringStart_x0 * y;
                self.centroidX2 = self.centroidX2 + z * (self.ringStart_x0 + x);
                self.centroidY2 = self.centroidY2 + z * (self.ringStart_y0 + y);
                self.centroidZ2 = self.centroidZ2 + z * 3.0;
                centroidPoint.handle(self.ringStart_x0 = x, self.ringStart_y0 = y, Double.NaN);
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler centroidRingStart_point = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                self.setPointDelegate(centroidRingStart_nextPoint);
                centroidPoint.handle(self.ringStart_x00 = (self.ringStart_x0 = x), self.ringStart_y00 = (self.ringStart_y0 = y), Double.NaN);
            }
        };
        final DelegatingStreamListener.StreamStateHandler centroidRingStart_lineEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                centroidRingStart_nextPoint.handle(self.ringStart_x00, self.ringStart_y00, Double.NaN);
            }
        };
        final DelegatingStreamListener.StreamStateHandler centroidRingStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.ringStart_x00 = (self.ringStart_y00 = (self.ringStart_x0 = (self.ringStart_y0 = 0.0)));
                self.setPointDelegate(centroidRingStart_point);
                self.setLineEndDelegate(centroidRingStart_lineEnd);
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setLineStartDelegate(centroidRingStart);
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setPointDelegate(centroidPoint);
                self.setLineStartDelegate(centroidLineStart);
                self.setLineEndDelegate(centroidLineEnd);
            }
        };
        this.setPointDelegate(centroidPoint);
        this.setLineStartDelegate(centroidLineStart);
        this.setLineEndDelegate(centroidLineEnd);
        this.setPolygonStartDelegate(polygonStart);
        this.setPolygonEndDelegate(polygonEnd);
    }

    final double getCentroidX0() {
        return this.centroidX0;
    }

    final double getCentroidY0() {
        return this.centroidY0;
    }

    final double getCentroidZ0() {
        return this.centroidZ0;
    }

    final double getCentroidX1() {
        return this.centroidX1;
    }

    final double getCentroidY1() {
        return this.centroidY1;
    }

    final double getCentroidZ1() {
        return this.centroidZ1;
    }

    final double getCentroidX2() {
        return this.centroidX2;
    }

    final double getCentroidY2() {
        return this.centroidY2;
    }

    final double getCentroidZ2() {
        return this.centroidZ2;
    }
}

