/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geo.InvertiblePointProjector;
import com.ibm.rave.core.geo.PointProjector;
import com.ibm.rave.core.geo.PointProjectorFactory;
import com.ibm.rave.core.geo.Projection;
import com.ibm.rave.core.geo.StreamListener;
import com.ibm.rave.core.geo.TransformStreamListener;
import com.ibm.rave.core.geo.TransformStreamListenerFactory;
import com.ibm.rave.core.internal.geo.ClipExtentStreamListenerFactory;
import com.ibm.rave.core.internal.geo.ClipStreamListenerFactory;
import com.ibm.rave.core.internal.geo.ClipUtil;
import com.ibm.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.rave.core.internal.geo.ProjectionMutatorImpl;
import com.ibm.rave.core.internal.geo.ResamplePointProjector;
import com.ibm.rave.core.internal.geo.ResampleStreamListenerFactory;
import com.ibm.rave.core.internal.geo.SphericalRotation;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;

public class ProjectionImpl
implements Projection {
    private double x = 480.0;
    private double y = 250.0;
    private double \u03bb = 0.0;
    private double \u03c6 = 0.0;
    private double \u03b4\u03bb = 0.0;
    private double \u03b4\u03c6 = 0.0;
    private double \u03b4\u03b3 = 0.0;
    protected double k = 150.0;
    protected double \u03b4x;
    protected double \u03b4y;
    private Double clipAngleValue = null;
    private ArrayEx<ArrayEx<Double>> clipExtentValue = null;
    private PointProjector pointProjector;
    private InvertiblePointProjector rotator;
    private ResampleStreamListenerFactory projectResample;
    private ClipStreamListenerFactory preclip;
    private ClipExtentStreamListenerFactory postclip = null;
    private TransformStreamListener streamListener;
    protected PointProjector projectRotate;

    protected ProjectionImpl() {
        final ProjectionImpl self = this;
        this.projectResample = new ResampleStreamListenerFactory(new ResamplePointProjector(){

            @Override
            public double[] project(double x, double y, double z) {
                double[] result = self.pointProjector.project(x, y);
                return new double[]{result[0] * self.k + self.\u03b4x, self.\u03b4y - result[1] * self.k};
            }
        });
        this.preclip = ClipUtil.newAntimeridianClipLineStreamListenerFactory();
    }

    @Override
    public ArrayEx<Double> project(ArrayEx<Double> point) {
        double[] p = this.projectRotate.project((Double)point.get(0) * (Math.PI / 180), (Double)point.get(1) * (Math.PI / 180));
        return new ArrayEx<Double>(p[0] * this.k + this.\u03b4x, this.\u03b4y - p[1] * this.k);
    }

    @Override
    public boolean supportInversion() {
        return false;
    }

    @Override
    public final boolean supportStreaming() {
        return true;
    }

    @Override
    public ArrayEx<Double> rotate() {
        return new ArrayEx<Double>(this.\u03b4\u03bb * 57.29577951308232, this.\u03b4\u03c6 * 57.29577951308232, this.\u03b4\u03b3 * 57.29577951308232);
    }

    @Override
    public Projection rotate(ArrayEx<Double> rotation) {
        this.\u03b4\u03bb = (Double)rotation.get(0) % 360.0 * (Math.PI / 180);
        this.\u03b4\u03c6 = (Double)rotation.get(1) % 360.0 * (Math.PI / 180);
        this.\u03b4\u03b3 = rotation.length() > 2 ? (Double)rotation.get(2) % 360.0 * (Math.PI / 180) : 0.0;
        return this.reset();
    }

    @Override
    public ArrayEx<Double> center() {
        return new ArrayEx<Double>(this.\u03bb * 57.29577951308232, this.\u03c6 * 57.29577951308232);
    }

    @Override
    public Projection center(ArrayEx<Double> c) {
        this.\u03bb = (Double)c.get(0) % 360.0 * (Math.PI / 180);
        this.\u03c6 = (Double)c.get(1) % 360.0 * (Math.PI / 180);
        return this.reset();
    }

    @Override
    public ArrayEx<Double> translate() {
        return new ArrayEx<Double>(this.x, this.y);
    }

    @Override
    public Projection translate(ArrayEx<? extends Object> t) {
        this.x = ObjectConverter.toDouble(t.get(0));
        this.y = ObjectConverter.toDouble(t.get(1));
        return this.reset();
    }

    @Override
    public Double scale() {
        return this.k;
    }

    @Override
    public Projection scale(Object s) {
        this.k = ObjectConverter.toDouble(s);
        return this.reset();
    }

    @Override
    public Double clipAngle() {
        return this.clipAngleValue;
    }

    @Override
    public Projection clipAngle(Object a) {
        if (a == null) {
            this.clipAngleValue = null;
            this.preclip = ClipUtil.newAntimeridianClipLineStreamListenerFactory();
        } else {
            this.clipAngleValue = ObjectConverter.toDouble(a);
            this.preclip = ClipUtil.newClipCircleStreamListenerFactory(this.clipAngleValue * (Math.PI / 180));
        }
        return this.invalidate();
    }

    @Override
    public ArrayEx<ArrayEx<Double>> clipExtent() {
        return this.clipExtentValue;
    }

    @Override
    public Projection clipExtent(ArrayEx<ArrayEx<Double>> e) {
        this.clipExtentValue = e;
        this.postclip = e != null ? ClipUtil.newClipExtentStreamListenerFactory((Double)((ArrayEx)e.get(0)).get(0), (Double)((ArrayEx)e.get(0)).get(1), (Double)((ArrayEx)e.get(1)).get(0), (Double)((ArrayEx)e.get(1)).get(1)) : null;
        return this.invalidate();
    }

    @Override
    public Double precision() {
        return this.projectResample.precision();
    }

    @Override
    public Projection precision(Double p) {
        this.projectResample.precision(p);
        return this;
    }

    @Override
    public TransformStreamListener stream(StreamListener listener) {
        if (this.streamListener != null) {
            this.streamListener.setValid(false);
        }
        this.streamListener = ProjectionImpl.projectionRadians(this.preclip.stream(this.rotator, this.projectResample.resample(this.postclip != null ? this.postclip.stream(listener) : listener)));
        this.streamListener.setValid(true);
        return this.streamListener;
    }

    protected final PointProjector getPointProjector() {
        return this.pointProjector;
    }

    protected final void setPointProjector(PointProjector project) {
        this.pointProjector = project;
    }

    protected Projection reset() {
        this.rotator = SphericalRotation.rotation(this.\u03b4\u03bb, this.\u03b4\u03c6, this.\u03b4\u03b3);
        this.projectRotate = SphericalRotation.compose(this.rotator, this.pointProjector);
        double[] center = this.pointProjector.project(this.\u03bb, this.\u03c6);
        this.\u03b4x = this.x - center[0] * this.k;
        this.\u03b4y = this.y + center[1] * this.k;
        return this.invalidate();
    }

    protected Projection invalidate() {
        if (this.streamListener != null) {
            this.streamListener.setValid(false);
            this.streamListener = null;
        }
        return this;
    }

    static TransformStreamListener projectionRadians(final StreamListener stream) {
        return TransformStreamListenerFactory.transformPoint(stream, new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                stream.point(x * (Math.PI / 180), y * (Math.PI / 180), Double.NaN);
            }
        });
    }

    public static Projection newProjection(final PointProjector projetor) {
        return ProjectionMutatorImpl.newProjectionMutator(new PointProjectorFactory(){

            @Override
            public PointProjector create(Object ... args) {
                return projetor;
            }
        }).mutate(new Object[0]);
    }
}

