/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.geo.StreamListener;
import com.ibm.rave.core.internal.geo.CartesianUtil;
import com.ibm.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.rave.core.internal.geo.ResampleStreamListenerFactory;

class ResampleStreamListener
extends DelegatingStreamListener {
    private double \u03bb00;
    private double \u03c600;
    private double x00;
    private double y00;
    private double a00;
    private double b00;
    private double c00;
    private double \u03bb0;
    private double x0;
    private double y0;
    private double a0;
    private double b0;
    private double c0;
    private final ResampleStreamListenerFactory factory;
    private final StreamListener listener;

    ResampleStreamListener(ResampleStreamListenerFactory factory, StreamListener listener) {
        this.factory = factory;
        this.listener = listener;
        final ResampleStreamListener self = this;
        final DelegatingStreamListener.StreamPointStateHandler point = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                double[] res = self.factory.getPointProjector().project(x, y, z);
                self.listener.point(res[0], res[1], Double.NaN);
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler linePoint = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double z) {
                double[] c = CartesianUtil.cartesian(new double[]{\u03bb, \u03c6});
                double[] p = self.factory.getPointProjector().project(\u03bb, \u03c6, Double.NaN);
                self.resampleLineTo(self.x0, self.y0, self.\u03bb0, self.a0, self.b0, self.c0, self.x0 = p[0], self.y0 = p[1], self.\u03bb0 = \u03bb, self.a0 = c[0], self.b0 = c[1], self.c0 = c[2], self.factory.getMaxDepth(), self.listener);
                self.listener.point(self.x0, self.y0, z);
            }
        };
        final DelegatingStreamListener.StreamStateHandler lineStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.x0 = Double.NaN;
                self.setPointDelegate(linePoint);
                self.listener.lineStart();
            }
        };
        final DelegatingStreamListener.StreamStateHandler lineEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setPointDelegate(point);
                self.listener.lineEnd();
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler ringPoint = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double z) {
                linePoint.handle(self.\u03bb00 = \u03bb, self.\u03c600 = \u03c6, z);
                self.x00 = self.x0;
                self.y00 = self.y0;
                self.a00 = self.a0;
                self.b00 = self.b0;
                self.c00 = self.c0;
                self.setPointDelegate(linePoint);
            }
        };
        final DelegatingStreamListener.StreamStateHandler ringEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.resampleLineTo(self.x0, self.y0, self.\u03bb0, self.a0, self.b0, self.c0, self.x00, self.y00, self.\u03bb00, self.a00, self.b00, self.c00, self.factory.getMaxDepth(), self.listener);
                self.setLineEndDelegate(lineEnd);
                lineEnd.handle();
            }
        };
        final DelegatingStreamListener.StreamStateHandler ringStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                lineStart.handle();
                self.setPointDelegate(ringPoint);
                self.setLineEndDelegate(ringEnd);
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.listener.polygonStart();
                self.setLineStartDelegate(ringStart);
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.listener.polygonEnd();
                self.setLineStartDelegate(lineStart);
            }
        };
        this.setPointDelegate(point);
        this.setLineStartDelegate(lineStart);
        this.setLineEndDelegate(lineEnd);
        this.setPolygonStartDelegate(polygonStart);
        this.setPolygonEndDelegate(polygonEnd);
    }

    private void resampleLineTo(double x0, double y0, double \u03bb0, double a0, double b0, double c0, double x1, double y1, double \u03bb1, double a1, double b1, double c1, int depth, StreamListener listener) {
        int _depth = depth;
        double dx = x1 - x0;
        double dy = y1 - y0;
        double d2 = dx * dx + dy * dy;
        if (d2 > 4.0 * this.factory.getPrecisionSquared() && _depth-- > 0) {
            boolean test3;
            double a = a0 + a1;
            double b = b0 + b1;
            double c = c0 + c1;
            double m = Math.sqrt(a * a + b * b + c * c);
            double \u03c62 = Math.asin(c /= m);
            double \u03bb2 = Math.abs(Math.abs(c) - 1.0) < 1.0E-6 || Math.abs(\u03bb0 - \u03bb1) < 1.0E-6 ? (\u03bb0 + \u03bb1) / 2.0 : Math.atan2(b, a);
            double[] p = this.factory.getPointProjector().project(\u03bb2, \u03c62, Double.NaN);
            double x2 = p[0];
            double y2 = p[1];
            double dx2 = x2 - x0;
            double dy2 = y2 - y0;
            double dz = dy * dx2 - dx * dy2;
            boolean test1 = dz * dz / d2 > this.factory.getPrecisionSquared();
            boolean test2 = Math.abs((dx * dx2 + dy * dy2) / d2 - 0.5) > 0.3;
            boolean bl = test3 = a0 * a1 + b0 * b1 + c0 * c1 < this.factory.getCosMinDistance();
            if (test1 || test2 || test3) {
                this.resampleLineTo(x0, y0, \u03bb0, a0, b0, c0, x2, y2, \u03bb2, a /= m, b /= m, c, _depth, listener);
                listener.point(x2, y2, Double.NaN);
                this.resampleLineTo(x2, y2, \u03bb2, a, b, c, x1, y1, \u03bb1, a1, b1, c1, _depth, listener);
            }
        }
    }
}

