/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.geo.Geo;
import com.ibm.rave.core.geo.StreamListener;
import com.ibm.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.rave.core.internal.math.Adder;

public final class SphericalArea {
    private double \u03bb00;
    private double \u03c600;
    private double \u03bb0;
    private double cos\u03c60;
    private double sin\u03c60;
    private double areaSum;
    private final Adder areaRingSum = new Adder();
    private final DelegatingStreamListener areaStreamListener = new DelegatingStreamListener();
    private final DelegatingStreamListener.StreamStateHandler sphere;
    private final DelegatingStreamListener.StreamStateHandler polygonStart;
    private final DelegatingStreamListener.StreamStateHandler polygonEnd;
    private final DelegatingStreamListener.StreamPointStateHandler point;
    private final DelegatingStreamListener.StreamPointStateHandler nextPoint;
    private final DelegatingStreamListener.StreamStateHandler lineEnd;
    private final DelegatingStreamListener.StreamStateHandler areaRingStart;

    public SphericalArea() {
        final SphericalArea self = this;
        this.sphere = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.areaSum = self.areaSum + Math.PI * 4;
            }
        };
        this.polygonStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.areaRingSum.reset();
                self.areaStreamListener.setLineStartDelegate(self.areaRingStart);
            }
        };
        this.polygonEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                double area = 2.0 * self.areaRingSum.valueOf();
                self.areaSum = self.areaSum + (area < 0.0 ? Math.PI * 4 + area : area);
                self.areaStreamListener.setLineStartDelegate(null);
                self.areaStreamListener.setLineEndDelegate(null);
                self.areaStreamListener.setPointDelegate(null);
            }
        };
        this.point = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double z) {
                double _\u03c6 = \u03c6;
                self.\u03bb0 = (self.\u03bb00 = \u03bb) * (Math.PI / 180);
                _\u03c6 = (self.\u03c600 = _\u03c6) * (Math.PI / 180) / 2.0 + 0.7853981633974483;
                self.cos\u03c60 = Math.cos(_\u03c6);
                self.sin\u03c60 = Math.sin(_\u03c6);
                self.areaStreamListener.setPointDelegate(self.nextPoint);
            }
        };
        this.nextPoint = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double z) {
                double _\u03bb = \u03bb * (Math.PI / 180);
                double _\u03c6 = \u03c6 * (Math.PI / 180) / 2.0 + 0.7853981633974483;
                double d\u03bb = _\u03bb - self.\u03bb0;
                double sd\u03bb = d\u03bb >= 0.0 ? 1.0 : -1.0;
                double ad\u03bb = sd\u03bb * d\u03bb;
                double cos\u03c6 = Math.cos(_\u03c6);
                double sin\u03c6 = Math.sin(_\u03c6);
                double k = self.sin\u03c60 * sin\u03c6;
                double u = self.cos\u03c60 * cos\u03c6 + k * Math.cos(ad\u03bb);
                double v = k * sd\u03bb * Math.sin(ad\u03bb);
                self.areaRingSum.add(Math.atan2(v, u));
                self.\u03bb0 = _\u03bb;
                self.cos\u03c60 = cos\u03c6;
                self.sin\u03c60 = sin\u03c6;
            }
        };
        this.lineEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.nextPoint.handle(self.\u03bb00, self.\u03c600, Double.NaN);
            }
        };
        this.areaRingStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.\u03bb00 = (self.\u03c600 = (self.\u03bb0 = (self.cos\u03c60 = (self.sin\u03c60 = 0.0))));
                self.areaStreamListener.setPointDelegate(self.point);
                self.areaStreamListener.setLineEndDelegate(self.lineEnd);
            }
        };
        this.areaStreamListener.setSphereDelegate(this.sphere);
        this.areaStreamListener.setPolygonStartDelegate(this.polygonStart);
        this.areaStreamListener.setPolygonEndDelegate(this.polygonEnd);
    }

    public final Adder getAreaRingSum() {
        return this.areaRingSum;
    }

    public final StreamListener getAreaStreamListener() {
        return this.areaStreamListener;
    }

    public final double calculateArea(JSONObject json) {
        this.areaSum = 0.0;
        Geo.INSTANCE.stream(json, this.areaStreamListener);
        return this.areaSum;
    }
}

