/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.geo.Geo;
import com.ibm.rave.core.geo.StreamListener;
import com.ibm.rave.core.internal.geo.CartesianUtil;
import com.ibm.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.rave.core.internal.geo.SphericalArea;
import com.ibm.rave.core.internal.geo.SphericalUtil;
import com.ibm.rave.core.util.Comparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SphericalBounds {
    private static final double[][] NULL_BOUNDS = new double[][]{{Double.NaN, Double.NaN}, {Double.NaN, Double.NaN}};
    private double \u03bb0;
    private double \u03c60;
    private double \u03bb1;
    private double \u03c61;
    private double \u03bb_;
    private double \u03bb__;
    private double \u03c6__;
    private double d\u03bbSum;
    private double[] p0;
    private double[] range;
    private List<double[]> ranges;
    private final SphericalArea sphericalArea = new SphericalArea();
    private final StreamListener areaStreamListener = this.sphericalArea.getAreaStreamListener();
    private final DelegatingStreamListener boundsStreamListener = new DelegatingStreamListener();
    private final Comparator<double[]> rangeComparator = new Comparator<double[]>(){

        @Override
        public int compare(double[] a, double[] b) {
            double diff = a[0] - b[0];
            if (diff > 0.0) {
                return 1;
            }
            if (diff < 0.0) {
                return -1;
            }
            return 0;
        }
    };
    private final DelegatingStreamListener.StreamPointStateHandler point;
    private final DelegatingStreamListener.StreamPointStateHandler linePoint;
    private final DelegatingStreamListener.StreamStateHandler lineStart;
    private final DelegatingStreamListener.StreamStateHandler lineEnd;
    private final DelegatingStreamListener.StreamPointStateHandler ringPoint;
    private final DelegatingStreamListener.StreamStateHandler ringStart;
    private final DelegatingStreamListener.StreamStateHandler ringEnd;
    private final DelegatingStreamListener.StreamStateHandler polygonStart;
    private final DelegatingStreamListener.StreamStateHandler polygonEnd;

    public SphericalBounds() {
        final SphericalBounds self = this;
        this.point = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double z) {
                SphericalBounds.access$002(self, new double[]{self.\u03bb0 = \u03bb, self.\u03bb1 = \u03bb});
                self.ranges.add(self.range);
                if (\u03c6 < self.\u03c60) {
                    self.\u03c60 = \u03c6;
                }
                if (\u03c6 > self.\u03c61) {
                    self.\u03c61 = \u03c6;
                }
            }
        };
        this.linePoint = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double z) {
                double[] p = CartesianUtil.cartesian(new double[]{\u03bb * (Math.PI / 180), \u03c6 * (Math.PI / 180)});
                if (self.p0 != null) {
                    double[] normal = CartesianUtil.cartesianCross(self.p0, p);
                    double[] equatorial = new double[]{normal[1], -normal[0], 0.0};
                    double[] inflection = CartesianUtil.cartesianCross(equatorial, normal);
                    CartesianUtil.cartesianNormalize(inflection);
                    inflection = SphericalUtil.spherical(inflection);
                    double d\u03bb = \u03bb - self.\u03bb_;
                    double s = d\u03bb > 0.0 ? 1.0 : -1.0;
                    double \u03bbi = inflection[0] * 57.29577951308232 * s;
                    boolean antimeridian = Math.abs(d\u03bb) > 180.0;
                    if (antimeridian ^ (s * self.\u03bb_ < \u03bbi && \u03bbi < s * \u03bb)) {
                        double \u03c6i = inflection[1] * 57.29577951308232;
                        if (\u03c6i > self.\u03c61) {
                            self.\u03c61 = \u03c6i;
                        }
                    } else {
                        \u03bbi = (\u03bbi + 360.0) % 360.0 - 180.0;
                        if (antimeridian ^ (s * self.\u03bb_ < \u03bbi && \u03bbi < s * \u03bb)) {
                            double \u03c6i = -inflection[1] * 57.29577951308232;
                            if (\u03c6i < self.\u03c60) {
                                self.\u03c60 = \u03c6i;
                            }
                        } else {
                            if (\u03c6 < self.\u03c60) {
                                self.\u03c60 = \u03c6;
                            }
                            if (\u03c6 > self.\u03c61) {
                                self.\u03c61 = \u03c6;
                            }
                        }
                    }
                    if (antimeridian) {
                        if (\u03bb < self.\u03bb_) {
                            if (self.angle(self.\u03bb0, \u03bb) > self.angle(self.\u03bb0, self.\u03bb1)) {
                                self.\u03bb1 = \u03bb;
                            }
                        } else if (self.angle(\u03bb, self.\u03bb1) > self.angle(self.\u03bb0, self.\u03bb1)) {
                            self.\u03bb0 = \u03bb;
                        }
                    } else if (self.\u03bb1 >= self.\u03bb0) {
                        if (\u03bb < self.\u03bb0) {
                            self.\u03bb0 = \u03bb;
                        }
                        if (\u03bb > self.\u03bb1) {
                            self.\u03bb1 = \u03bb;
                        }
                    } else if (\u03bb > self.\u03bb_) {
                        if (self.angle(self.\u03bb0, \u03bb) > self.angle(self.\u03bb0, self.\u03bb1)) {
                            self.\u03bb1 = \u03bb;
                        }
                    } else if (self.angle(\u03bb, self.\u03bb1) > self.angle(self.\u03bb0, self.\u03bb1)) {
                        self.\u03bb0 = \u03bb;
                    }
                } else {
                    self.point.handle(\u03bb, \u03c6, Double.NaN);
                }
                SphericalBounds.access$602(self, p);
                self.\u03bb_ = \u03bb;
            }
        };
        this.lineStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.boundsStreamListener.setPointDelegate(self.linePoint);
            }
        };
        this.lineEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                ((SphericalBounds)self).range[0] = self.\u03bb0;
                ((SphericalBounds)self).range[1] = self.\u03bb1;
                self.boundsStreamListener.setPointDelegate(self.point);
                SphericalBounds.access$602(self, null);
            }
        };
        this.ringPoint = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double z) {
                if (self.p0 != null) {
                    double d\u03bb = \u03bb - self.\u03bb_;
                    self.d\u03bbSum = self.d\u03bbSum + (Math.abs(d\u03bb) > 180.0 ? d\u03bb + (double)(d\u03bb > 0.0 ? 360 : -360) : d\u03bb);
                } else {
                    self.\u03bb__ = \u03bb;
                    self.\u03c6__ = \u03c6;
                }
                self.areaStreamListener.point(\u03bb, \u03c6, Double.NaN);
                self.linePoint.handle(\u03bb, \u03c6, Double.NaN);
            }
        };
        this.ringStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.areaStreamListener.lineStart();
            }
        };
        this.ringEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.ringPoint.handle(self.\u03bb__, self.\u03c6__, Double.NaN);
                self.areaStreamListener.lineEnd();
                if (Math.abs(self.d\u03bbSum) > 1.0E-6) {
                    self.\u03bb0 = -(self.\u03bb1 = 180.0);
                }
                ((SphericalBounds)self).range[0] = self.\u03bb0;
                ((SphericalBounds)self).range[1] = self.\u03bb1;
                SphericalBounds.access$602(self, null);
            }
        };
        this.polygonStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.boundsStreamListener.setPointDelegate(self.ringPoint);
                self.boundsStreamListener.setLineStartDelegate(self.ringStart);
                self.boundsStreamListener.setLineEndDelegate(self.ringEnd);
                self.d\u03bbSum = 0.0;
                self.areaStreamListener.polygonStart();
            }
        };
        this.polygonEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.areaStreamListener.polygonEnd();
                self.boundsStreamListener.setPointDelegate(self.point);
                self.boundsStreamListener.setLineStartDelegate(self.lineStart);
                self.boundsStreamListener.setLineEndDelegate(self.lineEnd);
                if (self.sphericalArea.getAreaRingSum().valueOf() < 0.0) {
                    self.\u03bb0 = -(self.\u03bb1 = 180.0);
                    self.\u03c60 = -(self.\u03c61 = 90.0);
                } else if (self.d\u03bbSum > 1.0E-6) {
                    self.\u03c61 = 90.0;
                } else if (self.d\u03bbSum < -1.0E-6) {
                    self.\u03c60 = -90.0;
                }
                ((SphericalBounds)self).range[0] = self.\u03bb0;
                ((SphericalBounds)self).range[1] = self.\u03bb1;
            }
        };
        this.boundsStreamListener.setPointDelegate(this.point);
        this.boundsStreamListener.setLineStartDelegate(this.lineStart);
        this.boundsStreamListener.setLineEndDelegate(this.lineEnd);
        this.boundsStreamListener.setPolygonStartDelegate(this.polygonStart);
        this.boundsStreamListener.setPolygonEndDelegate(this.polygonEnd);
    }

    private boolean withinRange(double x, double[] range) {
        return range[0] <= range[1] ? range[0] <= x && x <= range[1] : x < range[0] || range[1] < x;
    }

    private double angle(double \u03bb0, double \u03bb1) {
        double d;
        double _\u03bb1 = \u03bb1;
        return d < 0.0 ? _\u03bb1 + 360.0 : (_\u03bb1 -= \u03bb0);
    }

    public double[][] calculateBounds(JSONObject feature) {
        Object object;
        this.\u03c60 = Double.POSITIVE_INFINITY;
        this.\u03bb0 = Double.POSITIVE_INFINITY;
        this.\u03c61 = this.\u03bb1 = -Double.POSITIVE_INFINITY;
        this.ranges = new ArrayList<double[]>();
        Geo.INSTANCE.stream(feature, this.boundsStreamListener);
        int n = this.ranges.size();
        if (n > 0) {
            double[] b;
            Collections.sort(this.ranges, this.rangeComparator);
            double[] a = this.ranges.get(0);
            ArrayList<double[]> merged = new ArrayList<double[]>();
            merged.add(a);
            for (int i = 1; i < n; ++i) {
                b = this.ranges.get(i);
                if (this.withinRange(b[0], a) || this.withinRange(b[1], a)) {
                    if (this.angle(a[0], b[1]) > this.angle(a[0], a[1])) {
                        a[1] = b[1];
                    }
                    if (!(this.angle(b[0], a[1]) > this.angle(a[0], a[1]))) continue;
                    a[0] = b[0];
                    continue;
                }
                a = b;
                merged.add(b);
            }
            double best = Double.NEGATIVE_INFINITY;
            n = merged.size() - 1;
            a = (double[])merged.get(n);
            for (int i = 0; i <= n; ++i) {
                double d;
                b = (double[])merged.get(i);
                double d\u03bb = this.angle(a[1], b[0]);
                if (d > best) {
                    best = d\u03bb;
                    this.\u03bb0 = b[0];
                    this.\u03bb1 = a[1];
                }
                a = b;
            }
        }
        this.ranges = null;
        this.range = null;
        if (this.\u03bb0 == Double.POSITIVE_INFINITY || this.\u03c60 == Double.POSITIVE_INFINITY) {
            object = NULL_BOUNDS;
        } else {
            double[][] dArrayArray = new double[2][];
            dArrayArray[0] = new double[]{this.\u03bb0, this.\u03c60};
            object = dArrayArray;
            dArrayArray[1] = new double[]{this.\u03bb1, this.\u03c61};
        }
        return object;
    }

    static /* synthetic */ double[] access$002(SphericalBounds x0, double[] x1) {
        x0.range = x1;
        return x1;
    }

    static /* synthetic */ double[] access$602(SphericalBounds x0, double[] x1) {
        x0.p0 = x1;
        return x1;
    }
}

