/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.internal.math.Trigonometry;
import com.ibm.rave.core.interpolate.Interpolator;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;

public final class SphericalInterpolation {
    public static Interpolator<double[]> newInterpolator(double[] source, double[] target) {
        final double x0 = source[0] * (Math.PI / 180);
        final double y0 = source[1] * (Math.PI / 180);
        double x1 = target[0] * (Math.PI / 180);
        double y1 = target[1] * (Math.PI / 180);
        double cy0 = Math.cos(y0);
        final double sy0 = Math.sin(y0);
        double cy1 = Math.cos(y1);
        final double sy1 = Math.sin(y1);
        final double kx0 = cy0 * Math.cos(x0);
        final double ky0 = cy0 * Math.sin(x0);
        final double kx1 = cy1 * Math.cos(x1);
        final double ky1 = cy1 * Math.sin(x1);
        final double d = 2.0 * Math.asin(Math.sqrt(Trigonometry.haversin(y1 - y0) + cy0 * cy1 * Trigonometry.haversin(x1 - x0)));
        final double k = 1.0 / Math.sin(d);
        if (ObjectConverter.toBoolean(d)) {
            return new Interpolator<double[]>(){

                @Override
                public double[] interpolate(double t) {
                    double _t = t;
                    double B = Math.sin(_t *= d) * k;
                    double A = Math.sin(d - _t) * k;
                    double x = A * kx0 + B * kx1;
                    double y = A * ky0 + B * ky1;
                    double z = A * sy0 + B * sy1;
                    return new double[]{Math.atan2(y, x) * 57.29577951308232, Math.atan2(z, Math.sqrt(x * x + y * y)) * 57.29577951308232};
                }
            };
        }
        return new Interpolator<double[]>(){

            @Override
            public double[] interpolate(double t) {
                return new double[]{x0 * 57.29577951308232, y0 * 57.29577951308232};
            }
        };
    }
}

