/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.internal.math.Trigonometry;

public final class SphericalUtil {
    private SphericalUtil() {
    }

    public static double[] spherical(double[] cartesian) {
        return new double[]{Math.atan2(cartesian[1], cartesian[0]), Trigonometry.asin(cartesian[2])};
    }

    public static boolean sphericalEqual(double[] a, double[] b) {
        return Math.abs(a[0] - b[0]) < 1.0E-6 && Math.abs(a[1] - b[1]) < 1.0E-6;
    }

    public static double calculateDistance(double[] a, double[] b) {
        double \u0394\u03bb = (b[0] - a[0]) * (Math.PI / 180);
        double \u03c60 = a[1] * (Math.PI / 180);
        double \u03c61 = b[1] * (Math.PI / 180);
        double sin\u0394\u03bb = Math.sin(\u0394\u03bb);
        double cos\u0394\u03bb = Math.cos(\u0394\u03bb);
        double sin\u03c60 = Math.sin(\u03c60);
        double cos\u03c60 = Math.cos(\u03c60);
        double sin\u03c61 = Math.sin(\u03c61);
        double cos\u03c61 = Math.cos(\u03c61);
        double t = cos\u03c61 * sin\u0394\u03bb;
        double d = t * t;
        t = cos\u03c60 * sin\u03c61 - sin\u03c60 * cos\u03c61 * cos\u0394\u03bb;
        return Math.atan2(Math.sqrt(d + t * t), sin\u03c60 * sin\u03c61 + cos\u03c60 * cos\u03c61 * cos\u0394\u03bb);
    }
}

