/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.core.geo.StreamListener;
import com.ibm.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import java.util.List;

public final class Stream {
    public static final Stream INSTANCE = new Stream();
    private static final ES6Map<String, GeoJSONObjectHandler> handlers = Stream.createAndInit();

    private static ES6Map<String, GeoJSONObjectHandler> createAndInit() {
        ES6Map<String, GeoJSONObjectHandler> _handlers = ES6Map.create();
        _handlers.set("FeatureCollection", new GeoJSONObjectHandler(){

            @Override
            public void handleObject(JSONObject featureCollection, StreamListener listener) {
                List features = (List)featureCollection.get((Object)"features");
                if (features != null) {
                    int n = features.size();
                    for (int i = 0; i < n; ++i) {
                        GeoJSONObjectHandler handler;
                        JSONObject geometry;
                        JSONObject feature = (JSONObject)features.get(i);
                        if (feature == null || (geometry = (JSONObject)feature.get((Object)"geometry")) == null || (handler = (GeoJSONObjectHandler)handlers.get((String)geometry.get((Object)"type"))) == null) continue;
                        handler.handleObject(geometry, listener);
                    }
                }
            }
        });
        _handlers.set("Feature", new GeoJSONObjectHandler(){

            @Override
            public void handleObject(JSONObject feature, StreamListener listener) {
                GeoJSONObjectHandler handler;
                JSONObject geometry = (JSONObject)feature.get((Object)"geometry");
                if (geometry != null && (handler = (GeoJSONObjectHandler)handlers.get((String)geometry.get((Object)"type"))) != null) {
                    handler.handleObject(geometry, listener);
                }
            }
        });
        _handlers.set("Sphere", new GeoJSONObjectHandler(){

            @Override
            public void handleObject(JSONObject json, StreamListener listener) {
                listener.sphere();
            }
        });
        _handlers.set("Point", new GeoJSONObjectHandler(){

            @Override
            public void handleObject(JSONObject json, StreamListener listener) {
                List coordinates = (List)json.get((Object)"coordinates");
                if (coordinates != null) {
                    if (coordinates.size() == 2) {
                        listener.point(ObjectConverter.toDouble(coordinates.get(0)), ObjectConverter.toDouble(coordinates.get(1)), Double.NaN);
                    } else if (coordinates.size() == 3) {
                        listener.point(ObjectConverter.toDouble(coordinates.get(0)), ObjectConverter.toDouble(coordinates.get(1)), ObjectConverter.toDouble(coordinates.get(2)));
                    }
                }
            }
        });
        _handlers.set("MultiPoint", new GeoJSONObjectHandler(){

            @Override
            public void handleObject(JSONObject json, StreamListener listener) {
                List coordinatesList = (List)json.get((Object)"coordinates");
                if (coordinatesList != null) {
                    int n = coordinatesList.size();
                    int i = -1;
                    while (++i < n) {
                        List coordinates = (List)coordinatesList.get(i);
                        if (coordinates == null) continue;
                        if (coordinates.size() == 2) {
                            listener.point(ObjectConverter.toDouble(coordinates.get(0)), ObjectConverter.toDouble(coordinates.get(1)), Double.NaN);
                            continue;
                        }
                        if (coordinates.size() != 3) continue;
                        listener.point(ObjectConverter.toDouble(coordinates.get(0)), ObjectConverter.toDouble(coordinates.get(1)), ObjectConverter.toDouble(coordinates.get(2)));
                    }
                }
            }
        });
        _handlers.set("LineString", new GeoJSONObjectHandler(){

            @Override
            public void handleObject(JSONObject json, StreamListener listener) {
                List coordinatesList = (List)json.get((Object)"coordinates");
                if (coordinatesList != null) {
                    Stream.streamLine(coordinatesList, listener, 0);
                }
            }
        });
        _handlers.set("MultiLineString", new GeoJSONObjectHandler(){

            @Override
            public void handleObject(JSONObject json, StreamListener listener) {
                List coordinatesList = (List)json.get((Object)"coordinates");
                if (coordinatesList != null) {
                    int n = coordinatesList.size();
                    int i = -1;
                    while (++i < n) {
                        List coordinates = (List)coordinatesList.get(i);
                        if (coordinates == null) continue;
                        Stream.streamLine(coordinates, listener, 0);
                    }
                }
            }
        });
        _handlers.set("Polygon", new GeoJSONObjectHandler(){

            @Override
            public void handleObject(JSONObject json, StreamListener listener) {
                List coordinatesList = (List)json.get((Object)"coordinates");
                if (coordinatesList != null) {
                    Stream.streamPolygon(coordinatesList, listener);
                }
            }
        });
        _handlers.set("MultiPolygon", new GeoJSONObjectHandler(){

            @Override
            public void handleObject(JSONObject json, StreamListener listener) {
                List coordinatesList = (List)json.get((Object)"coordinates");
                if (coordinatesList != null) {
                    int n = coordinatesList.size();
                    int i = -1;
                    while (++i < n) {
                        List coordinates = (List)coordinatesList.get(i);
                        if (coordinates == null) continue;
                        Stream.streamPolygon(coordinates, listener);
                    }
                }
            }
        });
        _handlers.set("GeometryCollection", new GeoJSONObjectHandler(){

            @Override
            public void handleObject(JSONObject json, StreamListener listener) {
                List geometries = (List)json.get((Object)"geometries");
                if (geometries != null) {
                    int i = -1;
                    int n = geometries.size();
                    while (++i < n) {
                        GeoJSONObjectHandler handler;
                        JSONObject geometry = (JSONObject)geometries.get(i);
                        if (geometry == null || (handler = (GeoJSONObjectHandler)handlers.get((String)geometry.get((Object)"type"))) == null) continue;
                        handler.handleObject(geometry, listener);
                    }
                }
            }
        });
        return _handlers;
    }

    private Stream() {
    }

    private static void streamLine(List coordinatesList, StreamListener listener, int closed) {
        int i = -1;
        int n = coordinatesList.size() - closed;
        listener.lineStart();
        while (++i < n) {
            List coordinates = (List)coordinatesList.get(i);
            if (coordinates == null) continue;
            if (coordinates.size() == 2) {
                listener.point(ObjectConverter.toDouble(coordinates.get(0)), ObjectConverter.toDouble(coordinates.get(1)), Double.NaN);
                continue;
            }
            if (coordinates.size() != 3) continue;
            listener.point(ObjectConverter.toDouble(coordinates.get(0)), ObjectConverter.toDouble(coordinates.get(1)), ObjectConverter.toDouble(coordinates.get(2)));
        }
        listener.lineEnd();
    }

    private static void streamPolygon(List coordinatesList, StreamListener listener) {
        int i = -1;
        int n = coordinatesList.size();
        listener.polygonStart();
        while (++i < n) {
            List coordList = (List)coordinatesList.get(i);
            if (coordList == null) continue;
            Stream.streamLine(coordList, listener, 1);
        }
        listener.polygonEnd();
    }

    public void stream(JSONObject json, StreamListener listener) {
        GeoJSONObjectHandler handler;
        if (json != null && listener != null && (handler = handlers.get((String)json.get((Object)"type"))) != null) {
            handler.handleObject(json, listener);
        }
    }

    @FunctionClass(value="handleObject")
    @SwiftClosure(value="handleObject")
    private static interface GeoJSONObjectHandler {
        public void handleObject(JSONObject var1, StreamListener var2);
    }
}

