/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geo;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geo.Projection;
import com.ibm.rave.core.internal.geo.MercatorProjection;

public final class TransverseMercatorProjection
extends MercatorProjection {
    TransverseMercatorProjection() {
    }

    @Override
    protected void init() {
        super.init();
        super.rotate(new ArrayEx<Double>(0.0, 0.0, 90.0));
    }

    @Override
    public ArrayEx<Double> rotate() {
        ArrayEx<Double> r = super.rotate();
        return new ArrayEx<Double>((Double)r.get(0), (Double)r.get(1), (Double)r.get(2) - 90.0);
    }

    @Override
    public Projection rotate(ArrayEx<Double> r) {
        return super.rotate(new ArrayEx<Double>((Double)r.get(0), (Double)r.get(1), r.length() > 2 ? (Double)r.get(2) + 90.0 : 90.0));
    }

    @Override
    public ArrayEx<Double> center() {
        ArrayEx<Double> c = super.center();
        return new ArrayEx<Double>((Double)c.get(1), -((Double)c.get(0)).doubleValue());
    }

    @Override
    public Projection center(ArrayEx<Double> c) {
        return super.center(new ArrayEx<Double>(-((Double)c.get(1)).doubleValue(), (Double)c.get(0)));
    }
}

