/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geom.voronoi;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiCircle;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiContext;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiEdge;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiRedBlackTree;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;

public class VoronoiBeach
extends VoronoiCircle {
    public VoronoiBeach() {
        VoronoiRedBlackTree.voronoiRedBlackNode(this);
    }

    public static VoronoiBeach voronoiCreateBeach(VoronoiContext context, VoronoiEdge.VoronoiSite site) {
        VoronoiCircle beach = context.voronoiBeachPool.pop();
        if (beach == null) {
            beach = new VoronoiBeach();
        }
        beach.site = site;
        return (VoronoiBeach)beach;
    }

    public static void voronoiDetachBeach(VoronoiContext context, VoronoiCircle beach) {
        VoronoiCircle.voronoiDetachCircle(context, beach);
        context.voronoiBeaches.remove(beach);
        context.voronoiBeachPool.push((VoronoiCircle[])new VoronoiCircle[]{beach});
        VoronoiRedBlackTree.voronoiRedBlackNode(beach);
    }

    public static void voronoiRemoveBeach(VoronoiContext context, VoronoiCircle beach) {
        VoronoiCircle circle = beach.circle;
        double x = circle.x;
        double y = circle.cy;
        VoronoiEdge.VoronoiSite vertex = new VoronoiEdge.VoronoiSite(x, y);
        VoronoiCircle previous = beach.P;
        VoronoiCircle next = beach.N;
        ArrayEx<VoronoiCircle> disappearing = new ArrayEx<VoronoiCircle>(beach);
        VoronoiBeach.voronoiDetachBeach(context, beach);
        VoronoiCircle lArc = previous;
        while (lArc.circle != null && Math.abs(x - lArc.circle.x) < 1.0E-6 && Math.abs(y - lArc.circle.cy) < 1.0E-6) {
            previous = lArc.P;
            disappearing.unshift((VoronoiCircle[])new VoronoiCircle[]{lArc});
            VoronoiBeach.voronoiDetachBeach(context, lArc);
            lArc = previous;
        }
        disappearing.unshift((VoronoiCircle[])new VoronoiCircle[]{lArc});
        VoronoiBeach.voronoiDetachCircle(context, lArc);
        VoronoiCircle rArc = next;
        while (rArc.circle != null && Math.abs(x - rArc.circle.x) < 1.0E-6 && Math.abs(y - rArc.circle.cy) < 1.0E-6) {
            next = rArc.N;
            disappearing.push((VoronoiCircle[])new VoronoiCircle[]{rArc});
            VoronoiBeach.voronoiDetachBeach(context, rArc);
            rArc = next;
        }
        disappearing.push((VoronoiCircle[])new VoronoiCircle[]{rArc});
        VoronoiCircle.voronoiDetachCircle(context, rArc);
        int nArcs = disappearing.length();
        for (int iArc = 1; iArc < nArcs; ++iArc) {
            rArc = (VoronoiCircle)disappearing.get(iArc);
            lArc = (VoronoiCircle)disappearing.get(iArc - 1);
            VoronoiEdge.voronoiSetEdgeEnd(rArc.edge, lArc.site, rArc.site, vertex);
        }
        lArc = (VoronoiCircle)disappearing.get(0);
        rArc = (VoronoiCircle)disappearing.get(nArcs - 1);
        rArc.edge = VoronoiEdge.voronoiCreateEdge(context, lArc.site, rArc.site, null, vertex);
        VoronoiCircle.voronoiAttachCircle(context, lArc);
        VoronoiCircle.voronoiAttachCircle(context, rArc);
    }

    public static void voronoiAddBeach(VoronoiContext context, VoronoiEdge.VoronoiSite site) {
        double x = site.x;
        double directrix = site.y;
        VoronoiCircle lArc = null;
        VoronoiCircle rArc = null;
        VoronoiCircle node = context.voronoiBeaches.root;
        while (node != null) {
            double dxl = VoronoiBeach.voronoiLeftBreakPoint(node, directrix) - x;
            if (dxl > 1.0E-6) {
                node = node.L;
                continue;
            }
            double dxr = x - VoronoiBeach.voronoiRightBreakPoint(node, directrix);
            if (dxr > 1.0E-6) {
                if (node.R == null) {
                    lArc = node;
                    break;
                }
                node = node.R;
                continue;
            }
            if (dxl > -1.0E-6) {
                lArc = node.P;
                rArc = node;
                break;
            }
            if (dxr > -1.0E-6) {
                lArc = node;
                rArc = node.N;
                break;
            }
            rArc = node;
            lArc = rArc;
            break;
        }
        VoronoiBeach newArc = VoronoiBeach.voronoiCreateBeach(context, site);
        context.voronoiBeaches.insert(lArc, newArc);
        if (lArc == null && rArc == null) {
            return;
        }
        if (lArc == rArc) {
            VoronoiCircle.voronoiDetachCircle(context, lArc);
            rArc = VoronoiBeach.voronoiCreateBeach(context, lArc.site);
            context.voronoiBeaches.insert(newArc, rArc);
            newArc.edge = rArc.edge = VoronoiEdge.voronoiCreateEdge(context, lArc.site, newArc.site, null, null);
            VoronoiCircle.voronoiAttachCircle(context, lArc);
            VoronoiCircle.voronoiAttachCircle(context, rArc);
            return;
        }
        if (rArc == null) {
            newArc.edge = VoronoiEdge.voronoiCreateEdge(context, lArc.site, newArc.site, null, null);
            return;
        }
        VoronoiCircle.voronoiDetachCircle(context, lArc);
        VoronoiCircle.voronoiDetachCircle(context, rArc);
        VoronoiEdge.VoronoiSite lSite = lArc.site;
        double ax = lSite.x;
        double ay = lSite.y;
        double bx = site.x - ax;
        double by = site.y - ay;
        VoronoiEdge.VoronoiSite rSite = rArc.site;
        double cx = rSite.x - ax;
        double cy = rSite.y - ay;
        double d = 2.0 * (bx * cy - by * cx);
        double hb = bx * bx + by * by;
        double hc = cx * cx + cy * cy;
        VoronoiEdge.VoronoiSite vertex = new VoronoiEdge.VoronoiSite((cy * hb - by * hc) / d + ax, (bx * hc - cx * hb) / d + ay);
        VoronoiEdge.voronoiSetEdgeEnd(rArc.edge, lSite, rSite, vertex);
        newArc.edge = VoronoiEdge.voronoiCreateEdge(context, lSite, site, null, vertex);
        rArc.edge = VoronoiEdge.voronoiCreateEdge(context, site, rSite, null, vertex);
        VoronoiCircle.voronoiAttachCircle(context, lArc);
        VoronoiCircle.voronoiAttachCircle(context, rArc);
    }

    private static double voronoiLeftBreakPoint(VoronoiCircle arc, double directrix) {
        VoronoiEdge.VoronoiSite site = arc.site;
        double rfocx = site.x;
        double rfocy = site.y;
        double pby2 = rfocy - directrix;
        if (!ObjectConverter.toBoolean(pby2)) {
            return rfocx;
        }
        VoronoiCircle lArc = arc.P;
        if (lArc == null) {
            return Double.NEGATIVE_INFINITY;
        }
        site = lArc.site;
        double lfocx = site.x;
        double lfocy = site.y;
        double plby2 = lfocy - directrix;
        if (!ObjectConverter.toBoolean(plby2)) {
            return lfocx;
        }
        double hl = lfocx - rfocx;
        double aby2 = 1.0 / pby2 - 1.0 / plby2;
        double b = hl / plby2;
        if (ObjectConverter.toBoolean(aby2)) {
            double sqRoot = Math.sqrt(b * b - 2.0 * aby2 * (hl * hl / (-2.0 * plby2) - lfocy + plby2 / 2.0 + rfocy - pby2 / 2.0));
            return (-b + sqRoot) / aby2 + rfocx;
        }
        return (rfocx + lfocx) / 2.0;
    }

    private static double voronoiRightBreakPoint(VoronoiCircle arc, double directrix) {
        VoronoiCircle rArc = arc.N;
        if (rArc != null) {
            return VoronoiBeach.voronoiLeftBreakPoint(rArc, directrix);
        }
        VoronoiEdge.VoronoiSite site = arc.site;
        return site.y == directrix ? site.x : Double.POSITIVE_INFINITY;
    }
}

