/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geom.voronoi;

import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiContext;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiEdge;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiRedBlackTree;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;

public class VoronoiCircle {
    public Double x = null;
    public Double y = null;
    @SwiftWeak(value=false)
    public VoronoiCircle arc = null;
    public VoronoiEdge.VoronoiSite site = null;
    @SwiftWeak(value=false)
    public VoronoiCircle circle = null;
    public Double cy = null;
    @SwiftWeak
    public VoronoiCircle P = null;
    @SwiftWeak
    public VoronoiCircle N = null;
    @SwiftWeak(value=false)
    public VoronoiCircle L = null;
    @SwiftWeak(value=false)
    public VoronoiCircle R = null;
    @SwiftWeak
    public VoronoiCircle U = null;
    public VoronoiEdge edge = null;
    public boolean C = false;

    public VoronoiCircle() {
        VoronoiRedBlackTree.voronoiRedBlackNode(this);
    }

    static void voronoiDetachCircle(VoronoiContext context, VoronoiCircle arc) {
        VoronoiCircle circle = arc.circle;
        if (ObjectConverter.toBoolean(circle)) {
            if (!ObjectConverter.toBoolean(circle.P)) {
                context.voronoiFirstCircle = circle.N;
            }
            context.voronoiCircles.remove(circle);
            context.voronoiCirclePool.push((VoronoiCircle[])new VoronoiCircle[]{circle});
            VoronoiRedBlackTree.voronoiRedBlackNode(circle);
            arc.circle = null;
        }
    }

    public static void voronoiAttachCircle(VoronoiContext context, VoronoiCircle arc) {
        VoronoiCircle lArc = arc.P;
        VoronoiCircle rArc = arc.N;
        if (lArc == null || rArc == null) {
            return;
        }
        VoronoiEdge.VoronoiSite lSite = lArc.site;
        VoronoiEdge.VoronoiSite cSite = arc.site;
        VoronoiEdge.VoronoiSite rSite = rArc.site;
        if (lSite == rSite) {
            return;
        }
        double bx = cSite.x;
        double ax = lSite.x - bx;
        double by = cSite.y;
        double cy = rSite.y - by;
        double ay = lSite.y - by;
        double cx = rSite.x - bx;
        double d = 2.0 * (ax * cy - ay * cx);
        if (d >= -1.0E-12) {
            return;
        }
        double ha = ax * ax + ay * ay;
        double hc = cx * cx + cy * cy;
        double x = (cy * ha - ay * hc) / d;
        double y = (ax * hc - cx * ha) / d;
        cy = y + by;
        VoronoiCircle circle = context.voronoiCirclePool.pop();
        if (!ObjectConverter.toBoolean(circle)) {
            circle = new VoronoiCircle();
        }
        circle.arc = arc;
        circle.site = cSite;
        circle.x = x + bx;
        circle.y = cy + Math.sqrt(x * x + y * y);
        circle.cy = cy;
        arc.circle = circle;
        VoronoiCircle before = null;
        VoronoiCircle node = context.voronoiCircles.root;
        while (ObjectConverter.toBoolean(node)) {
            if (circle.y < node.y || circle.y == node.y && circle.x <= node.x) {
                if (ObjectConverter.toBoolean(node.L)) {
                    node = node.L;
                    continue;
                }
                before = node.P;
                break;
            }
            if (ObjectConverter.toBoolean(node.R)) {
                node = node.R;
                continue;
            }
            before = node;
            break;
        }
        context.voronoiCircles.insert(before, circle);
        if (!ObjectConverter.toBoolean(before)) {
            context.voronoiFirstCircle = circle;
        }
    }
}

