/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geom.voronoi;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.ClipLine;
import com.ibm.rave.core.geom.PointStruct;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiContext;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiEdge;

public class VoronoiClip {
    private static ClipLine.PointCreator voronoiPointCreator = new ClipLine.PointCreator(){

        @Override
        public PointStruct apply(double x, double y) {
            return new VoronoiEdge.VoronoiSite(x, y);
        }
    };

    public static void voronoiClipEdges(VoronoiContext context, double[][] extent) {
        ArrayEx<VoronoiEdge> edges = context.voronoiEdges;
        ClipLine.LineClipper clip = ClipLine.create(extent[0][0], extent[0][1], extent[1][0], extent[1][1], voronoiPointCreator);
        int i = edges.length();
        VoronoiEdge e = null;
        while (i-- > 0) {
            e = (VoronoiEdge)edges.get(i);
            if (VoronoiClip.voronoiConnectEdge(e, extent) && clip.clip(e) != null && (!(Math.abs(e.getA().x - e.getB().x) < 1.0E-6) || !(Math.abs(e.getA().y - e.getB().y) < 1.0E-6))) continue;
            e.setA(null);
            e.setB(null);
            edges.splice(i, 1, (VoronoiEdge[])new VoronoiEdge[0]);
        }
    }

    private static boolean voronoiConnectEdge(VoronoiEdge edge, double[][] extent) {
        VoronoiEdge.VoronoiSite vb = (VoronoiEdge.VoronoiSite)edge.getB();
        if (vb != null) {
            return true;
        }
        VoronoiEdge.VoronoiSite va = (VoronoiEdge.VoronoiSite)edge.getA();
        double x0 = extent[0][0];
        double x1 = extent[1][0];
        double y0 = extent[0][1];
        double y1 = extent[1][1];
        VoronoiEdge.VoronoiSite lSite = edge.l;
        VoronoiEdge.VoronoiSite rSite = edge.r;
        double lx = lSite.x;
        double ly = lSite.y;
        double rx = rSite.x;
        double ry = rSite.y;
        double fx = (lx + rx) / 2.0;
        double fy = (ly + ry) / 2.0;
        if (ry == ly) {
            if (fx < x0 || fx >= x1) {
                return false;
            }
            if (lx > rx) {
                if (va == null) {
                    va = new VoronoiEdge.VoronoiSite(fx, y0);
                } else if (va.y >= y1) {
                    return false;
                }
                vb = new VoronoiEdge.VoronoiSite(fx, y1);
            } else {
                if (va == null) {
                    va = new VoronoiEdge.VoronoiSite(fx, y1);
                } else if (va.y < y0) {
                    return false;
                }
                vb = new VoronoiEdge.VoronoiSite(fx, y0);
            }
        } else {
            double fm = (lx - rx) / (ry - ly);
            double fb = fy - fm * fx;
            if (fm < -1.0 || fm > 1.0) {
                if (lx > rx) {
                    if (va == null) {
                        va = new VoronoiEdge.VoronoiSite((y0 - fb) / fm, y0);
                    } else if (va.y >= y1) {
                        return false;
                    }
                    vb = new VoronoiEdge.VoronoiSite((y1 - fb) / fm, y1);
                } else {
                    if (va == null) {
                        va = new VoronoiEdge.VoronoiSite((y1 - fb) / fm, y1);
                    } else if (va.y < y0) {
                        return false;
                    }
                    vb = new VoronoiEdge.VoronoiSite((y0 - fb) / fm, y0);
                }
            } else if (ly < ry) {
                if (va == null) {
                    va = new VoronoiEdge.VoronoiSite(x0, fm * x0 + fb);
                } else if (va.x >= x1) {
                    return false;
                }
                vb = new VoronoiEdge.VoronoiSite(x1, fm * x1 + fb);
            } else {
                if (va == null) {
                    va = new VoronoiEdge.VoronoiSite(x1, fm * x1 + fb);
                } else if (va.x < x0) {
                    return false;
                }
                vb = new VoronoiEdge.VoronoiSite(x0, fm * x0 + fb);
            }
        }
        edge.setA(va);
        edge.setB(vb);
        return true;
    }
}

