/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geom.voronoi;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiBeach;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiCell;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiCircle;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiClip;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiContext;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiEdge;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiRedBlackTree;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.util.Comparator;

public class VoronoiIndex {
    private static Comparator<VoronoiEdge.VoronoiSite> voronoiVertexOrder = new Comparator<VoronoiEdge.VoronoiSite>(){

        @Override
        public int compare(VoronoiEdge.VoronoiSite a, VoronoiEdge.VoronoiSite b) {
            double dresult = b.y - a.y;
            if (dresult == 0.0) {
                dresult = b.x - a.x;
            }
            if (dresult > 0.0) {
                return 1;
            }
            if (dresult < 0.0) {
                return -1;
            }
            return 0;
        }
    };

    public static VoronoiDiagram voronoi(VoronoiContext context, ArrayEx<VoronoiEdge.VoronoiSite> sites, double[][] bbox) {
        VoronoiEdge.VoronoiSite site = sites.sort(voronoiVertexOrder).pop();
        Double x0 = Double.NEGATIVE_INFINITY;
        Double y0 = Double.NEGATIVE_INFINITY;
        context.voronoiEdges = new ArrayEx();
        context.voronoiCells = new ArrayEx(sites.length());
        context.voronoiBeaches = new VoronoiRedBlackTree();
        context.voronoiCircles = new VoronoiRedBlackTree();
        while (true) {
            VoronoiCircle circle = context.voronoiFirstCircle;
            if (site != null && (circle == null || site.y < circle.y || site.y == circle.y && site.x < circle.x)) {
                if (site.x != x0 || site.y != y0) {
                    context.voronoiCells.set(site.i, new VoronoiCell(site));
                    VoronoiBeach.voronoiAddBeach(context, site);
                    x0 = site.x;
                    y0 = site.y;
                }
                site = sites.pop();
                continue;
            }
            if (circle == null) break;
            VoronoiBeach.voronoiRemoveBeach(context, circle.arc);
        }
        if (ObjectConverter.toBoolean(bbox)) {
            VoronoiClip.voronoiClipEdges(context, bbox);
            VoronoiCell.voronoiCloseCells(context, bbox);
        }
        VoronoiDiagram diagram = new VoronoiDiagram(context.voronoiCells, context.voronoiEdges);
        context.voronoiBeaches = null;
        context.voronoiCircles = null;
        context.voronoiEdges = null;
        context.voronoiCells = null;
        return diagram;
    }

    public static final class VoronoiDiagram {
        public ArrayEx<VoronoiEdge> voronoiEdges;
        public ArrayEx<VoronoiCell> voronoiCells;

        public VoronoiDiagram(ArrayEx<VoronoiCell> cells, ArrayEx<VoronoiEdge> edges) {
            this.voronoiEdges = edges;
            this.voronoiCells = cells;
        }
    }
}

