/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.geom.voronoi;

import com.ibm.rave.core.internal.geom.voronoi.VoronoiCircle;

public class VoronoiRedBlackTree {
    public VoronoiCircle root;

    public static void voronoiRedBlackNode(VoronoiCircle node) {
        node.U = null;
        node.C = false;
        node.L = null;
        node.R = null;
        node.P = null;
        node.N = null;
    }

    public void insert(VoronoiCircle after, VoronoiCircle node) {
        VoronoiCircle parent;
        VoronoiCircle _after = after;
        if (_after != null) {
            node.P = _after;
            node.N = _after.N;
            if (_after.N != null) {
                _after.N.P = node;
            }
            _after.N = node;
            if (_after.R != null) {
                _after = _after.R;
                while (_after.L != null) {
                    _after = _after.L;
                }
                _after.L = node;
            } else {
                _after.R = node;
            }
            parent = _after;
        } else if (this.root != null) {
            _after = VoronoiRedBlackTree.voronoiRedBlackFirst(this.root);
            node.P = null;
            node.N = _after;
            _after.P = _after.L = node;
            parent = _after;
        } else {
            node.N = null;
            node.P = null;
            this.root = node;
            parent = null;
        }
        node.R = null;
        node.L = null;
        node.U = parent;
        node.C = true;
        _after = node;
        while (parent != null && parent.C) {
            VoronoiCircle uncle;
            VoronoiCircle grandpa = parent.U;
            if (parent == grandpa.L) {
                uncle = grandpa.R;
                if (uncle != null && uncle.C) {
                    uncle.C = false;
                    parent.C = false;
                    grandpa.C = true;
                    _after = grandpa;
                } else {
                    if (_after == parent.R) {
                        VoronoiRedBlackTree.voronoiRedBlackRotateLeft(this, parent);
                        _after = parent;
                        parent = _after.U;
                    }
                    parent.C = false;
                    grandpa.C = true;
                    VoronoiRedBlackTree.voronoiRedBlackRotateRight(this, grandpa);
                }
            } else {
                uncle = grandpa.L;
                if (uncle != null && uncle.C) {
                    uncle.C = false;
                    parent.C = false;
                    grandpa.C = true;
                    _after = grandpa;
                } else {
                    if (_after == parent.L) {
                        VoronoiRedBlackTree.voronoiRedBlackRotateRight(this, parent);
                        _after = parent;
                        parent = _after.U;
                    }
                    parent.C = false;
                    grandpa.C = true;
                    VoronoiRedBlackTree.voronoiRedBlackRotateLeft(this, grandpa);
                }
            }
            parent = _after.U;
        }
        this.root.C = false;
    }

    public void remove(VoronoiCircle node) {
        Boolean red;
        VoronoiCircle _node = node;
        if (_node.N != null) {
            _node.N.P = _node.P;
        }
        if (_node.P != null) {
            _node.P.N = _node.N;
        }
        _node.P = null;
        _node.N = null;
        VoronoiCircle parent = _node.U;
        VoronoiCircle left = _node.L;
        VoronoiCircle right = _node.R;
        VoronoiCircle next = left == null ? right : (right == null ? left : VoronoiRedBlackTree.voronoiRedBlackFirst(right));
        if (parent != null) {
            if (parent.L == _node) {
                parent.L = next;
            } else {
                parent.R = next;
            }
        } else {
            this.root = next;
        }
        if (left != null && right != null) {
            red = next.C;
            next.C = _node.C;
            next.L = left;
            left.U = next;
            if (next != right) {
                parent = next.U;
                next.U = _node.U;
                parent.L = _node = next.R;
                next.R = right;
                right.U = next;
            } else {
                next.U = parent;
                parent = next;
                _node = next.R;
            }
        } else {
            red = _node.C;
            _node = next;
        }
        if (_node != null) {
            _node.U = parent;
        }
        if (red.booleanValue()) {
            return;
        }
        if (_node != null && _node.C) {
            _node.C = false;
            return;
        }
        while (_node != this.root) {
            VoronoiCircle sibling;
            if (_node == parent.L) {
                sibling = parent.R;
                if (sibling.C) {
                    sibling.C = false;
                    parent.C = true;
                    VoronoiRedBlackTree.voronoiRedBlackRotateLeft(this, parent);
                    sibling = parent.R;
                }
                if (sibling.L != null && sibling.L.C || sibling.R != null && sibling.R.C) {
                    if (sibling.R == null || !sibling.R.C) {
                        sibling.L.C = false;
                        sibling.C = true;
                        VoronoiRedBlackTree.voronoiRedBlackRotateRight(this, sibling);
                        sibling = parent.R;
                    }
                    sibling.C = parent.C;
                    sibling.R.C = false;
                    parent.C = false;
                    VoronoiRedBlackTree.voronoiRedBlackRotateLeft(this, parent);
                    _node = this.root;
                    break;
                }
            } else {
                sibling = parent.L;
                if (sibling.C) {
                    sibling.C = false;
                    parent.C = true;
                    VoronoiRedBlackTree.voronoiRedBlackRotateRight(this, parent);
                    sibling = parent.L;
                }
                if (sibling.L != null && sibling.L.C || sibling.R != null && sibling.R.C) {
                    if (sibling.L == null || !sibling.L.C) {
                        sibling.R.C = false;
                        sibling.C = true;
                        VoronoiRedBlackTree.voronoiRedBlackRotateLeft(this, sibling);
                        sibling = parent.L;
                    }
                    sibling.C = parent.C;
                    sibling.L.C = false;
                    parent.C = false;
                    VoronoiRedBlackTree.voronoiRedBlackRotateRight(this, parent);
                    _node = this.root;
                    break;
                }
            }
            sibling.C = true;
            _node = parent;
            parent = parent.U;
            if (!_node.C) continue;
        }
        if (_node != null) {
            _node.C = false;
        }
    }

    public static void voronoiRedBlackRotateLeft(VoronoiRedBlackTree tree, VoronoiCircle node) {
        VoronoiCircle p = node;
        VoronoiCircle q = node.R;
        VoronoiCircle parent = p.U;
        if (parent != null) {
            if (parent.L == p) {
                parent.L = q;
            } else {
                parent.R = q;
            }
        } else {
            tree.root = q;
        }
        q.U = parent;
        p.U = q;
        p.R = q.L;
        if (p.R != null) {
            p.R.U = p;
        }
        q.L = p;
    }

    public static void voronoiRedBlackRotateRight(VoronoiRedBlackTree tree, VoronoiCircle node) {
        VoronoiCircle p = node;
        VoronoiCircle q = node.L;
        VoronoiCircle parent = p.U;
        if (parent != null) {
            if (parent.L == p) {
                parent.L = q;
            } else {
                parent.R = q;
            }
        } else {
            tree.root = q;
        }
        q.U = parent;
        p.U = q;
        p.L = q.R;
        if (p.L != null) {
            p.L.U = p;
        }
        q.R = p;
    }

    static VoronoiCircle voronoiRedBlackFirst(VoronoiCircle node) {
        VoronoiCircle retVal = node;
        while (retVal.L != null) {
            retVal = retVal.L;
        }
        return retVal;
    }
}

