/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.globalization;

import com.ibm.rave.core.internal.globalization.AbstractNumericShaper;

public class NationalNumericShaper
extends AbstractNumericShaper {
    private final int nationalDigitCode;

    NationalNumericShaper(int nationDigitCode) {
        this.nationalDigitCode = nationDigitCode;
    }

    @Override
    public String shape(String text) {
        int digitCode = this.nationalDigitCode;
        if (text == null) {
            return null;
        }
        if (digitCode > offsets.length - 1) {
            return text;
        }
        int offset = offsets[digitCode];
        StringBuilder s = new StringBuilder();
        int minDigit = 48;
        int maxDigit = 57;
        for (int i = 0; i < text.length(); ++i) {
            int c = Character.codePointAt(text, i);
            if (c >= minDigit && c <= maxDigit) {
                s.append(Character.toString((char)(c + offset)));
                continue;
            }
            s.append(Character.toString((char)c));
        }
        return s.toString();
    }
}

