/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.nativeImpl;

import com.ibm.json.java.JSONArray;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import java.util.ArrayList;
import java.util.List;

public final class Lang {
    public static boolean greaterThan(Object a, Object b) {
        return Lang.compareObjects(a, b, CompareTypes.GREATER_THAN);
    }

    public static boolean lessThan(Object a, Object b) {
        return Lang.compareObjects(a, b, CompareTypes.LESS_THAN);
    }

    public static boolean greaterThanOrEqual(Object a, Object b) {
        return Lang.greaterThan(a, b) || Lang.equalTo(a, b);
    }

    private static boolean equalTo(Object a, Object b) {
        return Lang.compareObjects(a, b, CompareTypes.EQUAL);
    }

    public static boolean lessThanOrEqual(Object a, Object b) {
        return Lang.lessThan(a, b) || Lang.equalTo(a, b);
    }

    private static boolean compareObjects(Object a, Object b, CompareTypes compareType) {
        if (a instanceof String && b instanceof String) {
            return Lang.compareStrings(a == null ? "" : ObjectConverter.toString(a), b == null ? "" : ObjectConverter.toString(b), compareType);
        }
        return Lang.compareNumbers(ObjectConverter.toDouble(a), ObjectConverter.toDouble(b), compareType);
    }

    private static boolean compareStrings(String a, String b, CompareTypes compareType) {
        int result = a.compareTo(b);
        return Lang.compareNumbers(result, 0.0, compareType);
    }

    private static boolean compareNumbers(double _a, double _b, CompareTypes compareType) {
        switch (compareType) {
            case LESS_THAN: {
                return _a < _b;
            }
            case GREATER_THAN: {
                return _a > _b;
            }
            case EQUAL: {
                return _a == _b;
            }
        }
        return false;
    }

    public static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static boolean isNotEqual(Object a, Object b) {
        return !Lang.isEqual(a, b);
    }

    public static <T> List<T> toList(T[] array) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T a : array) {
            list.add(a);
        }
        return list;
    }

    public static <T> ArrayEx<T> toArray(T[] array) {
        ArrayEx<T> arr = new ArrayEx<T>(array.length);
        int i = 0;
        for (T a : array) {
            arr.set(i++, a);
        }
        return arr;
    }

    public static double[] asPrimitiveDouble(List<Double> list) {
        double[] arr = new double[list.size()];
        int i = 0;
        for (Double a : list) {
            arr[i++] = ObjectConverter.asDouble(a);
        }
        return arr;
    }

    public static <E> JSONArray toJSONArray(List<E> array) {
        JSONArray jsonArray = new JSONArray();
        for (E a : array) {
            if (a instanceof List) {
                jsonArray.add((Object)Lang.toJSONArray((List)a));
                continue;
            }
            jsonArray.add(a);
        }
        return jsonArray;
    }

    public static Integer[] asInteger(double[] range) {
        Integer[] ints = new Integer[range.length];
        for (int index = 0; index < range.length; ++index) {
            ints[index] = (int)range[index];
        }
        return ints;
    }

    public static Double[] asDouble(double[] range) {
        Double[] arr = new Double[range.length];
        for (int i = 0; i < range.length; ++i) {
            arr[i] = range[i];
        }
        return arr;
    }

    public static boolean isNumber(Object o) {
        return o instanceof Number;
    }

    public static boolean isBoolean(Object o) {
        return o instanceof Boolean;
    }

    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static boolean isList(Object o) {
        return o instanceof List;
    }

    public static boolean isString(Object o) {
        return o instanceof String;
    }

    public static boolean isObject(Object o) {
        return !Lang.isNumber(o) && !Lang.isBoolean(o) && !Lang.isArray(o) && !Lang.isString(o);
    }

    public static Object undefined() {
        return null;
    }

    public static boolean isFinite(Double d) {
        return !Double.isInfinite(d) && !Double.isNaN(d);
    }

    public static String join(Object[] arr, String separator) {
        if (arr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            sb.append(separator);
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String join(List<?> arr, String separator) {
        if (arr.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(arr.get(0));
        for (int i = 1; i < arr.size(); ++i) {
            sb.append(separator);
            sb.append(arr.get(i));
        }
        return sb.toString();
    }

    public static double now() {
        return System.currentTimeMillis();
    }

    public static double parseNumber(String n) {
        try {
            return Double.parseDouble(n);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static String substring(String s, int beginIndex, int endIndex) {
        return s.substring(Math.min(beginIndex, s.length()), Math.min(endIndex, s.length()));
    }

    private static enum CompareTypes {
        LESS_THAN,
        GREATER_THAN,
        EQUAL;

    }
}

