/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.nativeImpl;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.context.RaveContextManager;
import com.ibm.rave.core.internal.selector.EmptySceneNode;
import com.ibm.rave.core.scene.SceneNode;

@FunctionClass(value="init")
public class PlatformInitialization {
    @InlineStringConstant
    private static final String PLATFORM_INITIALIZATION_KEY = "PLATFORM_INITIALIZATION_KEY";

    private static PlatformInitializationNodes getPlatformInitializationNodes() {
        PlatformInitializationNodes platformInitializationNodes = (PlatformInitializationNodes)RaveContextManager.INSTANCE.getRaveContext().getData(PLATFORM_INITIALIZATION_KEY);
        if (platformInitializationNodes == null) {
            platformInitializationNodes = new PlatformInitializationNodes();
            RaveContextManager.INSTANCE.getRaveContext().putData(PLATFORM_INITIALIZATION_KEY, platformInitializationNodes);
        }
        return platformInitializationNodes;
    }

    public static void init() {
    }

    public static SceneNode getDocumentElement(SceneNode node) {
        return node != null ? PlatformInitialization.getRoot(node) : PlatformInitialization.getPlatformInitializationNodes().documentBodyElement;
    }

    public static SceneNode getWindow(SceneNode node) {
        return node != null ? PlatformInitialization.getRoot(node) : PlatformInitialization.getPlatformInitializationNodes().window;
    }

    public static SceneNode getDocument() {
        return PlatformInitialization.getPlatformInitializationNodes().document;
    }

    public static SceneNode getDocumentBodyElement() {
        return PlatformInitialization.getPlatformInitializationNodes().documentBodyElement;
    }

    private static SceneNode getRoot(SceneNode node) {
        SceneNode p;
        SceneNode root = node;
        while ((p = root.getParentNode()) != null) {
            root = p;
        }
        return root;
    }

    private static class PlatformInitializationNodes {
        final SceneNode window = new EmptySceneNode();
        final SceneNode document = new EmptySceneNode();
        final SceneNode documentBodyElement = new EmptySceneNode();

        private PlatformInitializationNodes() {
        }
    }
}

