/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.selector.mirror;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.Selector;

public class MirrorUtil {
    public static boolean isMirrored(SceneNode node) {
        return ObjectConverter.toBoolean(node.getProperty("__rave-mirrored__"));
    }

    public static boolean isGroupNode(SceneNode node) {
        return node != null && (ObjectConverter.toBoolean(node.getProperty("__rave-mirrored-group__")) || MirrorUtil.isOwnerGroupNode(node));
    }

    static boolean isOwnerGroupNode(SceneNode node) {
        return node != null && ObjectConverter.toBoolean(node.getProperty("__rave-owner-group-node-property__"));
    }

    static boolean isWrappableNode(SceneNode node) {
        int drawType = node.getDrawType();
        return drawType == 1003 || drawType == 1007;
    }

    static boolean isGroupOrOwnerNode(SceneNode node) {
        return node == node.getOwner() || node.getDrawType() == 1004;
    }

    public static boolean setRawNode(SceneNode node, boolean value) {
        SceneNode owner = node.getOwner();
        if (owner == null) {
            return true;
        }
        Object originalRawNode = owner.getProperty("__rave-raw-node-access__");
        owner.setProperty("__rave-raw-node-access__", value ? Boolean.valueOf(value) : null);
        return ObjectConverter.toBoolean(originalRawNode);
    }

    public static boolean isRawMode(SceneNode node) {
        SceneNode owner = node.getOwner();
        return owner == null ? true : ObjectConverter.toBoolean(owner.getProperty("__rave-raw-node-access__"));
    }

    static SceneNode createWrappingGroup(SceneNode context) {
        ArrayEx<SceneNode> existingChildren = new ArrayEx<SceneNode>();
        for (SceneNode child : context.getChildNodes()) {
            existingChildren.add(child);
        }
        Selector group = new Selector().init(context).append("g");
        group.property("__rave-mirrored-group__", true);
        group.property("__rave-owner-group-node-property__", true);
        group.property("__rave-mirrored__", true);
        SceneNode groupNode = group.node();
        for (SceneNode child : existingChildren) {
            groupNode.appendChild(child);
        }
        MirrorUtil.getExtendableNode(context).setProperty("__rave-group-node-property__", groupNode);
        return groupNode;
    }

    static boolean hasWrappingGroup(SceneNode context) {
        return ObjectConverter.toBoolean(MirrorUtil.getWrappingGroup(context));
    }

    static SceneNode getWrappingGroup(SceneNode context) {
        return (SceneNode)MirrorUtil.getExtendableNode(context).getProperty("__rave-group-node-property__");
    }

    public static SceneNode getExtendableNode(SceneNode node) {
        SceneNode canvas_root = (SceneNode)node.getProperty("__rave_canvas_root__");
        if (canvas_root != null) {
            return canvas_root;
        }
        return node;
    }
}

