/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.selector.mirror;

import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.selector.mirror.MirrorUtil;
import com.ibm.rave.core.internal.selector.mirror.MirroredSceneNodeHelper;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.transform.Matrix;
import java.util.List;

public class MirroredSceneNodeExtension {
    public static void extend(SceneNode node) {
        final SceneNode.GetChildNodesExtension origGetChildNodes = node.getChildNodesExt;
        final SceneNode.HasChildNodesExtension origHasChildNodes = node.hasChildNodesExt;
        final SceneNode.RemoveChildExtension origRemoveChild = node.removeChildExt;
        final SceneNode.GetParentNodeExtension origGetParent = node.getParentNodeExt;
        final SceneNode.AppendChildExtension origAppendChild = node.appendChildExt;
        final SceneNode.InsertBeforeExtension origInsertBefore = node.insertBeforeExt;
        final SceneNode.GetNextSiblingExtension origGetNextSibling = node.getNextSiblingExt;
        final SceneNode.GetPreviousSiblingExtension origGetPreviousSibling = node.getPreviousSiblingExt;
        final SceneNode.GetFirstChildExtension origGetFirstChild = node.getFirstChildExt;
        final SceneNode.SetTextExtension origSetTextExt = node.setTextExt;
        final SceneNode.SetStyleExtension origSetStyleExt = node.setStyleExt;
        final SceneNode.SetAttributeExtension origSetAttributeExt = node.setAttributeExt;
        final SceneNode.GetScreenCTMExtension origGetScreenCTM = node.getScreenCTMExt;
        final SceneNode.GetCTMExtension origGetCTM = node.getCTMExt;
        node.appendChildExt = new SceneNode.AppendChildExtension(){

            @Override
            public void appendChild(SceneNode context, SceneNode appendChild) {
                Rave.configuration.extendRecursive(appendChild);
                if (MirrorUtil.isRawMode(context)) {
                    origAppendChild.appendChild(context, appendChild);
                } else {
                    SceneNode appendNode = context;
                    SceneNode firstChild = origGetFirstChild.getFirstChild(context);
                    if (firstChild != null && MirrorUtil.isOwnerGroupNode(firstChild)) {
                        appendNode = firstChild;
                    }
                    origAppendChild.appendChild(appendNode, appendChild);
                    if (MirrorUtil.isMirrored(context)) {
                        MirroredSceneNodeHelper.mirrorNode(appendChild);
                    } else {
                        MirroredSceneNodeHelper.update(appendChild);
                    }
                }
            }
        };
        node.insertBeforeExt = new SceneNode.InsertBeforeExtension(){

            @Override
            public void insertBefore(SceneNode context, SceneNode insert, SceneNode before) {
                Rave.configuration.extendRecursive(insert);
                SceneNode parent = context;
                SceneNode beforeNode = before;
                if (MirrorUtil.isRawMode(context)) {
                    origInsertBefore.insertBefore(parent, insert, beforeNode);
                } else {
                    SceneNode firstChild = origGetFirstChild.getFirstChild(context);
                    if (firstChild != null && MirrorUtil.isOwnerGroupNode(firstChild)) {
                        parent = firstChild;
                    }
                    origInsertBefore.insertBefore(parent, insert, beforeNode);
                    if (MirrorUtil.isMirrored(context)) {
                        MirroredSceneNodeHelper.mirrorNode(insert);
                    } else {
                        MirroredSceneNodeHelper.update(insert);
                    }
                }
            }
        };
        node.getNextSiblingExt = new SceneNode.GetNextSiblingExtension(){

            @Override
            public SceneNode getNextSibling(SceneNode context) {
                return origGetNextSibling.getNextSibling(context);
            }
        };
        node.getPreviousSiblingExt = new SceneNode.GetPreviousSiblingExtension(){

            @Override
            public SceneNode getPreviousSibling(SceneNode context) {
                return origGetPreviousSibling.getPreviousSibling(context);
            }
        };
        node.getFirstChildExt = new SceneNode.GetFirstChildExtension(){

            @Override
            public SceneNode getFirstChild(SceneNode context) {
                SceneNode child = origGetFirstChild.getFirstChild(context);
                if (child != null && MirrorUtil.isGroupNode(child)) {
                    child = child.getFirstChild();
                }
                return child;
            }
        };
        node.hasChildNodesExt = new SceneNode.HasChildNodesExtension(){

            @Override
            public boolean hasChildNodes(SceneNode context) {
                SceneNode wrappedNode = MirrorUtil.getWrappingGroup(context);
                if (wrappedNode != null) {
                    return wrappedNode.hasChildNodes();
                }
                return origHasChildNodes.hasChildNodes(context);
            }
        };
        node.getChildNodesExt = new SceneNode.GetChildNodesExtension(){

            @Override
            public List<SceneNode> getChildNodes(SceneNode context) {
                if (MirrorUtil.isRawMode(context)) {
                    return origGetChildNodes.getChildNodes(context);
                }
                List<SceneNode> nodes = origGetChildNodes.getChildNodes(context);
                ArrayEx<SceneNode> nonGroupNodes = new ArrayEx<SceneNode>();
                for (SceneNode child : nodes) {
                    if (MirrorUtil.isGroupNode(child)) {
                        nonGroupNodes = nonGroupNodes.concat(child.getChildNodes());
                        continue;
                    }
                    nonGroupNodes.add(child);
                }
                return nonGroupNodes;
            }
        };
        node.removeChildExt = new SceneNode.RemoveChildExtension(){

            @Override
            public boolean removeChild(SceneNode context, SceneNode childNode) {
                if (MirrorUtil.isRawMode(context)) {
                    return origRemoveChild.removeChild(context, childNode);
                }
                SceneNode realChild = childNode;
                SceneNode parent = context;
                SceneNode group = MirrorUtil.getWrappingGroup(context);
                if (group != null && group != realChild) {
                    parent = group;
                }
                return origRemoveChild.removeChild(parent, realChild);
            }
        };
        node.getParentNodeExt = new SceneNode.GetParentNodeExtension(){

            @Override
            public SceneNode getParentNode(SceneNode context) {
                SceneNode origParent = origGetParent.getParentNode(context);
                if (origParent != null && MirrorUtil.isRawMode(origParent)) {
                    return origParent;
                }
                while (MirrorUtil.isGroupNode(origParent)) {
                    origParent = origGetParent.getParentNode(origParent);
                }
                return origParent;
            }
        };
        node.setAttributeExt = new SceneNode.SetAttributeExtension(){

            @Override
            public void setAttribute(SceneNode context, String key, Object value) {
                origSetAttributeExt.setAttribute(context, key, value);
                if (!MirrorUtil.isRawMode(context)) {
                    MirroredSceneNodeHelper.update(context);
                }
            }
        };
        node.setTextExt = new SceneNode.SetTextExtension(){

            @Override
            public void setText(SceneNode context, String text) {
                origSetTextExt.setText(context, text);
                MirroredSceneNodeHelper.update(context);
            }
        };
        node.setStyleExt = new SceneNode.SetStyleExtension(){

            @Override
            public void setStyle(SceneNode context, String styleName, Object value, String priority) {
                origSetStyleExt.setStyle(context, styleName, value, priority);
                if (!MirrorUtil.isRawMode(context) && styleName.equals("transform")) {
                    context.setProperty("__rave-original-style__", value);
                    MirroredSceneNodeHelper.update(context);
                }
            }
        };
        node.getScreenCTMExt = new SceneNode.GetScreenCTMExtension(){

            @Override
            public Matrix getScreenCTM(SceneNode context) {
                boolean origRawNode = MirrorUtil.setRawNode(context, true);
                Matrix ctm = origGetScreenCTM.getScreenCTM(context);
                MirrorUtil.setRawNode(context, origRawNode);
                return ctm;
            }
        };
        node.getCTMExt = new SceneNode.GetCTMExtension(){

            @Override
            public Matrix getCTM(SceneNode context) {
                boolean origRawNode = MirrorUtil.setRawNode(context, true);
                Matrix ctm = origGetCTM.getCTM(context);
                MirrorUtil.setRawNode(context, origRawNode);
                return ctm;
            }
        };
    }
}

