/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.transitions;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.event.Dispatcher;
import com.ibm.rave.core.internal.transitions.TransitionInfo;
import com.ibm.rave.core.internal.transitions.TransitionTracker;
import com.ibm.rave.core.scene.SceneNode;

public final class TransitionUtil {
    @InlineStringConstant
    private static final String TRANSITION_PROPERTY = "__transition_";

    public static TransitionInfo getTransitionInfo(SceneNode node, String namespace, int id) {
        TransitionTracker tracker = TransitionUtil.getTransitionTracker(node, namespace);
        TransitionInfo info = (TransitionInfo)tracker.get(id);
        if (info == null) {
            ++tracker.count;
            info = new TransitionInfo(tracker, id, node);
            tracker.put(id, info);
        }
        return info;
    }

    public static TransitionTracker getTransitionTracker(SceneNode node, String namespace) {
        TransitionTracker tracker = (TransitionTracker)node.getProperty(namespace);
        if (tracker == null) {
            tracker = new TransitionTracker();
            node.setProperty(namespace, tracker);
        }
        return tracker;
    }

    public static void disposeTransition(SceneNode node, String namespace) {
        node.removeProperty(namespace);
    }

    public static void interrupt(SceneNode node) {
        TransitionUtil.interruptNS(node, TransitionUtil.transitionNamespace(null));
    }

    public static void interruptNS(SceneNode node, String namespace) {
        TransitionInfo active;
        TransitionTracker tracker = (TransitionTracker)node.getProperty(namespace);
        if (tracker != null && (active = (TransitionInfo)tracker.get((int)tracker.active)) != null) {
            if (--tracker.count > 0) {
                tracker.remove((int)tracker.active);
            } else {
                TransitionUtil.disposeTransition(node, namespace);
            }
            tracker.active += 0.5;
            if (active.getDispatcher() != null) {
                ((Dispatcher.DispatcherEvent)active.getDispatcher().get("interrupt")).fire(node, node.getData(), active.getIndex());
            }
        }
    }

    public static String transitionNamespace(String name) {
        return name == null ? "__transition__" : TRANSITION_PROPERTY + name + "__";
    }
}

