/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.transitions;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.internal.selector.SelectorHelper;
import com.ibm.rave.core.internal.transitions.TransitionUtil;
import com.ibm.rave.core.interpolate.Interpolator;
import com.ibm.rave.core.interpolate.Interpolators;
import com.ibm.rave.core.interpolate.TransformInterpolation;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.transition.Transition;
import com.ibm.rave.core.transition.TransitionInterpolatorFactory;
import com.ibm.rave.core.transition.Tween;
import com.ibm.rave.core.util.QName;

public final class TweenFunctions {
    public static ValueFunction<SceneNode, Tween<SceneNode>> style(final String name, final Object value, final String priority) {
        return new ValueFunction<SceneNode, Tween<SceneNode>>(){

            @Override
            public Tween<SceneNode> getValue(SceneNode node, Object data, int index, int groupIndex) {
                Object startValue = node.getComputedStyle(name);
                Object v = value;
                if (v instanceof ValueFunction) {
                    v = ((ValueFunction)v).getValue(node, data, index, groupIndex);
                }
                if (v == null) {
                    node.removeStyle(name);
                    return null;
                }
                if (!Lang.isNumber(v) || !Lang.isNumber(startValue)) {
                    v = v + "";
                }
                if (Lang.isNotEqual(startValue, v)) {
                    final Interpolator<?> interpolator = Interpolators.INSTANCE.getInterpolator(startValue, v);
                    return new Tween<SceneNode>(){

                        @Override
                        public void tween(SceneNode tweenNode, double t) {
                            tweenNode.setStyle(name, interpolator.interpolate(t), priority);
                        }
                    };
                }
                return null;
            }
        };
    }

    public static ValueFunction<SceneNode, Tween<SceneNode>> styleTween(final String name, final TransitionInterpolatorFactory<SceneNode> factory, final String priority) {
        return new ValueFunction<SceneNode, Tween<SceneNode>>(){

            @Override
            public Tween<SceneNode> getValue(SceneNode node, Object data, int index, int groupIndex) {
                Object startValue = node.getComputedStyle(name);
                final Interpolator<?> interpolator = factory.create(node, data, index, startValue);
                if (interpolator != null) {
                    return new Tween<SceneNode>(){

                        @Override
                        public void tween(SceneNode tweenNode, double t) {
                            tweenNode.setStyle(name, interpolator.interpolate(t), priority);
                        }
                    };
                }
                return null;
            }
        };
    }

    public static ValueFunction<SceneNode, Tween<SceneNode>> attr(final QName qname, final Object value) {
        return new ValueFunction<SceneNode, Tween<SceneNode>>(){

            @Override
            public Tween<SceneNode> getValue(SceneNode node, Object data, int index, int groupIndex) {
                Object startValue = qname.space == null ? node.getAttribute(qname.local) : node.getAttributeNS(qname.space, qname.local);
                Object v = value;
                if (v instanceof ValueFunction) {
                    v = ((ValueFunction)v).getValue(node, data, index, groupIndex);
                }
                if (v == null) {
                    if (qname.space == null) {
                        node.removeAttribute(qname.local);
                    } else {
                        node.removeAttributeNS(qname.space, qname.local);
                    }
                    return null;
                }
                if (!Lang.isNumber(v) || !Lang.isNumber(startValue)) {
                    v = v + "";
                }
                if (Lang.isNotEqual(startValue, v)) {
                    Interpolator<?> interpolator;
                    Interpolator<Object> interpolator2 = "transform".equals(qname.local) && qname.space == null ? TransformInterpolation.INSTANCE.create(startValue == null ? null : ObjectConverter.toString(startValue), v == null ? null : ObjectConverter.toString(v)) : (interpolator = Interpolators.INSTANCE.getInterpolator(startValue, v));
                    if (qname.space == null) {
                        return new Tween<SceneNode>(){

                            @Override
                            public void tween(SceneNode tweenNode, double t) {
                                tweenNode.setAttribute(qname.local, interpolator.interpolate(t));
                            }
                        };
                    }
                    return new Tween<SceneNode>(){

                        @Override
                        public void tween(SceneNode tweenNode, double t) {
                            tweenNode.setAttributeNS(qname.space, qname.local, interpolator.interpolate(t));
                        }
                    };
                }
                return null;
            }
        };
    }

    public static ValueFunction<SceneNode, Tween<SceneNode>> attrTween(final QName qname, final TransitionInterpolatorFactory<SceneNode> factory) {
        return new ValueFunction<SceneNode, Tween<SceneNode>>(){

            @Override
            public Tween<SceneNode> getValue(SceneNode node, Object data, int index, int groupIndex) {
                Object startValue = qname.space == null ? node.getAttribute(qname.local) : node.getAttributeNS(qname.space, qname.local);
                final Interpolator<?> interpolator = factory.create(node, data, index, startValue);
                if (interpolator != null) {
                    if (qname.space == null) {
                        return new Tween<SceneNode>(){

                            @Override
                            public void tween(SceneNode tweenNode, double t) {
                                tweenNode.setAttribute(qname.local, interpolator.interpolate(t));
                            }
                        };
                    }
                    return new Tween<SceneNode>(){

                        @Override
                        public void tween(SceneNode tweenNode, double t) {
                            tweenNode.setAttributeNS(qname.space, qname.local, interpolator.interpolate(t));
                        }
                    };
                }
                return null;
            }
        };
    }

    public static Transition tween(Transition groups, final String name, final Object value, final GetTween getTween) {
        CallbackFunction<SceneNode> callback;
        final int id = groups.getId();
        final String namespace = groups.getNamespace();
        if (value instanceof ValueFunction) {
            callback = new CallbackFunction<SceneNode>(){

                @Override
                public void run(SceneNode node, Object data, int index, int groupIndex) {
                    TransitionUtil.getTransitionInfo(node, namespace, id).addTweenFactory(name, getTween.getTween(((ValueFunction)value).getValue(node, data, index, groupIndex)));
                }
            };
        } else {
            final ValueFunction<SceneNode, Tween<SceneNode>> tweenFactory = getTween.getTween(value);
            callback = new CallbackFunction<SceneNode>(){

                @Override
                public void run(SceneNode node, Object data, int index, int groupIndex) {
                    TransitionUtil.getTransitionInfo(node, namespace, id).addTweenFactory(name, tweenFactory);
                }
            };
        }
        return SelectorHelper.each(groups, (CallbackFunction<? super SceneNode>)callback);
    }

    @FunctionClass(value="getTween")
    @SwiftClosure(value="getTween")
    public static interface GetTween {
        public ValueFunction<SceneNode, Tween<SceneNode>> getTween(Object var1);
    }
}

