/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.interpolate;

import com.ibm.rave.core.interpolate.Interpolator;
import com.ibm.rave.core.interpolate.InterpolatorFactory;
import com.ibm.rave.core.interpolate.Interpolators;

public class ArrayInterpolation
implements InterpolatorFactory<Object[]> {
    public static final ArrayInterpolation INSTANCE = new ArrayInterpolation();

    @Override
    public final Interpolator<Object[]> create(Object[] a, Object[] b) {
        int na = a.length;
        int nb = b.length;
        final int n0 = Math.min(na, nb);
        int i = 0;
        final Interpolator[] x = new Interpolator[n0];
        final Object[] c = new Object[Math.max(na, nb)];
        for (i = 0; i < n0; ++i) {
            x[i] = Interpolators.INSTANCE.getInterpolator(a[i], b[i]);
        }
        while (i < na) {
            c[i] = a[i];
            ++i;
        }
        while (i < nb) {
            c[i] = b[i];
            ++i;
        }
        return new Interpolator<Object[]>(){

            @Override
            public Object[] interpolate(double t) {
                for (int index = 0; index < n0; ++index) {
                    c[index] = x[index].interpolate(t);
                }
                return c;
            }
        };
    }
}

