/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.interpolate;

import com.ibm.rave.core.color.Color;
import com.ibm.rave.core.color.Colors;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.interpolate.ArrayInterpolation;
import com.ibm.rave.core.interpolate.ColorInterpolation;
import com.ibm.rave.core.interpolate.Interpolator;
import com.ibm.rave.core.interpolate.InterpolatorFactory;
import com.ibm.rave.core.interpolate.NumberInterpolation;
import com.ibm.rave.core.interpolate.StringInterpolation;
import com.ibm.rave.core.nativeImpl.interpolate.ObjectInterpolation;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import java.util.ArrayList;

public class Interpolators
extends ArrayList<InterpolatorFactory<Object>> {
    public static Interpolators INSTANCE = new Interpolators().initialize();

    public Interpolators initialize() {
        this.add(new InterpolatorFactory<Object>(){

            @Override
            public Interpolator<?> create(Object a, Object b) {
                if (Lang.isString(b)) {
                    if (Colors.isRGBColorName((String)b) || ((String)b).matches("#[a-z|A-Z|0-9]*|rgba?\\(.*|hsla?\\(.*")) {
                        return ColorInterpolation.RGBINSTANCE.create(a, b);
                    }
                    return StringInterpolation.INSTANCE.create(a, b);
                }
                if (b instanceof Color) {
                    return ColorInterpolation.RGBINSTANCE.create(a, b);
                }
                if (Lang.isArray(b)) {
                    return ArrayInterpolation.INSTANCE.create((Object[])a, (Object[])b);
                }
                if (Lang.isList(b) || Lang.isObject(b) && ObjectConverter.isNaN(b)) {
                    return ObjectInterpolation.INSTANCE.create(a, b);
                }
                return NumberInterpolation.INSTANCE.create(a, b);
            }
        });
        return this;
    }

    public Interpolator<?> getInterpolator(Object a, Object b) {
        Interpolator<?> result = null;
        for (int i = this.size() - 1; result == null && i >= 0; --i) {
            result = ((InterpolatorFactory)this.get(i)).create(a, b);
        }
        return result;
    }
}

