/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.layout;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.layout.Link;
import com.ibm.rave.core.layout.Node;
import com.ibm.rave.core.selector.ValueFunction;

public class BundleLayout
implements ValueFunction<Object, Object[]> {
    @Override
    @SwiftMethodOverload(skip=true)
    public Object[] getValue(Object context, Object data, int index, int groupIndex) {
        return this.bundle((ArrayEx)data).toArray();
    }

    public ArrayEx<ArrayEx<Node>> bundle(ArrayEx<Link> links) {
        ArrayEx<ArrayEx<Node>> paths = new ArrayEx<ArrayEx<Node>>();
        int i = -1;
        int n = links.length();
        while (++i < n) {
            paths.push(this.layout_bundlePath((Link)links.get(i)));
        }
        return paths;
    }

    private ArrayEx<Node> layout_bundleAncestors(Node node) {
        Node _node = node;
        ArrayEx<Node> ancestors = new ArrayEx<Node>();
        Node parent = _node.parent;
        while (parent != null) {
            ancestors.push(_node);
            _node = parent;
            parent = parent.parent;
        }
        ancestors.push(_node);
        return ancestors;
    }

    private Node layout_bundleLeastCommonAncestor(Node a, Node b) {
        if (a == b) {
            return a;
        }
        ArrayEx<Node> aNodes = this.layout_bundleAncestors(a);
        ArrayEx<Node> bNodes = this.layout_bundleAncestors(b);
        Node aNode = aNodes.pop();
        Node bNode = bNodes.pop();
        Node sharedNode = null;
        while (aNode == bNode) {
            sharedNode = aNode;
            aNode = aNodes.pop();
            bNode = bNodes.pop();
        }
        return sharedNode;
    }

    private ArrayEx<Node> layout_bundlePath(Link link) {
        Node start = link.source;
        Node end = link.target;
        Node lca = this.layout_bundleLeastCommonAncestor(start, end);
        ArrayEx<Node> points = new ArrayEx<Node>(start);
        while (start != lca) {
            start = start.parent;
            points.push((Node[])new Node[]{start});
        }
        int k = points.length();
        while (end != lca) {
            points.splice(k, 0, (Node[])new Node[]{end});
            end = end.parent;
        }
        return points;
    }
}

