/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.layout;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.JsonArray;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.arrays.Bisector;
import com.ibm.rave.core.arrays.MinMax;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.ValueFunction;
import java.util.List;

public class HistogramLayout
implements ValueFunction<Object, Object[]> {
    private static double LN2 = Math.log(2.0);
    private boolean freqencyVal = true;
    private ArrayEx.ArrayValueFunction<Object, ? extends Number> valuerFn = DEFAULT_VALUER_FN;
    @SwiftWeak(value=false)
    private ValueFunction<HistogramLayout, ArrayEx<Object>> ranger = RANGER_DEFAULT_FN;
    private HistogramBinSturges binner = DEFAULT_BINNER_FN;
    private static ValueFunction<HistogramLayout, ArrayEx<Object>> RANGER_DEFAULT_FN = new ValueFunction<HistogramLayout, ArrayEx<Object>>(){

        @Override
        public ArrayEx<Object> getValue(HistogramLayout context, Object values, int index, int groupIndex) {
            return new ArrayEx<Object>(MinMax.min((ArrayEx)values), MinMax.max((ArrayEx)values));
        }
    };
    private static ArrayEx.ArrayValueFunction<Object, ? extends Number> DEFAULT_VALUER_FN = new ArrayEx.ArrayValueFunction<Object, Double>(){

        @Override
        public Double getValue(Object currentValue, int index, ArrayEx<Object> array) {
            return ObjectConverter.toDouble(currentValue);
        }
    };
    private static HistogramBinSturges DEFAULT_BINNER_FN = new HistogramBinSturges(){

        @Override
        public ArrayEx<Object> getValue(HistogramLayout context, ArrayEx<Object> range, Object values, int index) {
            return HistogramLayout.layout_histogramBinFixed(range, Math.ceil(Math.log(((ArrayEx)values).toArray().length) / LN2 + 1.0));
        }
    };

    @Override
    @SwiftMethodOverload(skip=true)
    public Object[] getValue(Object context, Object data, int index, int groupIndex) {
        return this.histogram((ArrayEx)data, index).toArray();
    }

    public ArrayEx<Bin> histogram(ArrayEx<Object> data) {
        return this.histogram(data, 0);
    }

    public ArrayEx<Bin> histogram(ArrayEx<Object> data, int index) {
        Bin bin;
        double k;
        ArrayEx<Bin> bins = new ArrayEx<Bin>();
        ArrayEx<? extends Number> values = data.map(this.valuerFn);
        ArrayEx<Object> range = this.ranger.getValue(this, values, index, -1);
        ArrayEx<Object> thresholds = this.binner.getValue(this, range, values, index);
        int i = -1;
        int n = values.length();
        int m = thresholds.length() - 1;
        double d = k = this.freqencyVal ? 1.0 : (double)(1 / n);
        while (++i < m) {
            bin = new Bin();
            bins.set(i, bin);
            bin.x = ObjectConverter.toDouble(thresholds.get(i));
            bin.dx = ObjectConverter.toDouble(thresholds.get(i + 1)) - bin.x;
            bin.y = 0.0;
        }
        if (m > 0) {
            i = -1;
            while (++i < n) {
                double x = ObjectConverter.toDouble(values.get(i));
                if (!(x >= ObjectConverter.toDouble(range.get(0))) || !(x <= ObjectConverter.toDouble(range.get(1)))) continue;
                bin = (Bin)bins.get(Bisector.bisect.bisect(thresholds, x, 1, m) - 1);
                bin.y += k;
                bin.add(data.get(i));
            }
        }
        return bins;
    }

    private ArrayEx<Object> layout_histogramRange(List<Object> values) {
        return new ArrayEx<Object>(MinMax.min(values), MinMax.max(values));
    }

    private static ArrayEx<Object> layout_histogramBinFixed(ArrayEx<Object> range, double n) {
        int x = -1;
        double b = ObjectConverter.toDouble(range.get(0));
        double m = (ObjectConverter.toDouble(range.get(1)) - b) / n;
        ArrayEx<Object> f = new ArrayEx<Object>();
        while ((double)(++x) <= n) {
            f.set(x, m * (double)x + b);
        }
        return f;
    }

    public boolean frequency() {
        return this.freqencyVal;
    }

    public HistogramLayout frequency(Boolean x) {
        this.freqencyVal = ObjectConverter.toBoolean(x);
        return this;
    }

    public HistogramBinSturges bins() {
        return this.binner;
    }

    public HistogramLayout bins(final Number x) {
        this.binner = new HistogramBinSturges(){

            @Override
            public ArrayEx<Object> getValue(HistogramLayout context, ArrayEx<Object> range, Object values, int index) {
                return HistogramLayout.layout_histogramBinFixed(range, ObjectConverter.asDouble(x));
            }
        };
        return this;
    }

    @SwiftMethodOverload(skip=true)
    public HistogramLayout bins(final Object x) {
        this.binner = x instanceof HistogramBinSturges ? (HistogramBinSturges)x : new HistogramBinSturges(){

            @Override
            public ArrayEx<Object> getValue(HistogramLayout context, ArrayEx<Object> range, Object values, int index) {
                return (ArrayEx)x;
            }
        };
        return this;
    }

    public ValueFunction<HistogramLayout, ArrayEx<Object>> range() {
        return this.ranger;
    }

    public HistogramLayout range(final ArrayEx<Object> range) {
        this.ranger = new ValueFunction<HistogramLayout, ArrayEx<Object>>(){

            @Override
            public ArrayEx<Object> getValue(HistogramLayout context, Object data, int index, int groupIndex) {
                return range;
            }
        };
        return this;
    }

    public HistogramLayout range(ValueFunction<HistogramLayout, ArrayEx<Object>> fn) {
        this.ranger = fn;
        return this;
    }

    public ArrayEx.ArrayValueFunction<Object, ? extends Number> value() {
        return this.valuerFn;
    }

    public HistogramLayout value(ArrayEx.ArrayValueFunction<Object, ? extends Number> x) {
        this.valuerFn = x;
        return this;
    }

    @FunctionClass(value="getValue", contextInvocation=true)
    @SwiftClosure(value="getValue")
    public static interface HistogramBinSturges {
        public ArrayEx<Object> getValue(HistogramLayout var1, ArrayEx<Object> var2, Object var3, int var4);
    }

    @JsonArray
    public static class Bin
    extends ArrayEx<Object> {
        public double dx = Double.NaN;
        public double y = Double.NaN;
        public double x = Double.NaN;
        public double dy = Double.NaN;
    }
}

