/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.layout.force;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.behavior.Behavior;
import com.ibm.rave.core.behavior.Drag;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.event.Dispatcher;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.QuadTree;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.layout.force.ForceLink;
import com.ibm.rave.core.layout.force.ForceNode;
import com.ibm.rave.core.math.Random;
import com.ibm.rave.core.nativeImpl.event.EventTracker;
import com.ibm.rave.core.nativeImpl.timer.Timer;
import com.ibm.rave.core.nativeImpl.timer.TimerEvent;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorEventListener;
import com.ibm.rave.core.selector.ValueFunction;
import java.util.List;

public final class Force {
    private Dim msize = new Dim(1.0, 1.0);
    private double malpha = 0.0;
    private double mfriction = 0.9;
    private Object mlinkDistance = 20;
    private Object mlinkStrength = 1;
    private Object mcharge = -30;
    private double mgravity = 0.1;
    private Drag mdrag;
    private double chargeDistance2 = Double.POSITIVE_INFINITY;
    private double theta2 = 0.64;
    private List<ForceNode> mnodes = new ArrayEx<ForceNode>();
    private ForceLink[] mlinks = new ForceLink[0];
    private double[] distances;
    private double[] strengths;
    private double[] charges;
    private final Dispatcher<EventObject> event = Dispatcher.create("start", "tick", "end");
    private final QuadTree<ForceNode> quadTree = new QuadTree<ForceNode>().x(fx).y(fy);
    private static final ValueFunction<Object, Drag.Origin> identity = new ValueFunction<Object, Drag.Origin>(){

        @Override
        public Drag.Origin getValue(Object context, Object data, int index, int groupIndex) {
            Drag.Origin o = new Drag.Origin();
            o.x = ((ForceNode)data).x;
            o.y = ((ForceNode)data).y;
            return o;
        }
    };
    public final ForceDrag drag;
    private final RunFunction<SceneNode> dragmove;
    private static final RunFunction<SceneNode> dragstart = new RunFunction<SceneNode>(){

        @Override
        public Object run(SceneNode context, Object ... args) {
            ForceNode d = (ForceNode)args[0];
            d.fixed |= 2;
            return null;
        }
    };
    private static final RunFunction<SceneNode> dragend = new RunFunction<SceneNode>(){

        @Override
        public Object run(SceneNode context, Object ... args) {
            ForceNode d = (ForceNode)args[0];
            d.fixed &= 0xFFFFFFF9;
            return null;
        }
    };
    private static final SelectorEventListener<?> mouseover = new SelectorEventListener<Event>(){

        @Override
        public void onEvent(SceneNode context, Object data, int index, int groupIndex, Event event) {
            ForceNode d = (ForceNode)data;
            d.fixed |= 4;
            d.px = d.x;
            d.py = d.y;
        }
    };
    private static final SelectorEventListener<?> mouseout = new SelectorEventListener<Event>(){

        @Override
        public void onEvent(SceneNode context, Object data, int index, int groupIndex, Event event) {
            ForceNode d = (ForceNode)data;
            d.fixed &= 0xFFFFFFFB;
        }
    };
    private static final QuadTree.ValueFunction<ForceNode> fx = new QuadTree.ValueFunction<ForceNode>(){

        @Override
        public double getValue(ForceNode node, int index) {
            return node.x;
        }
    };
    private static final QuadTree.ValueFunction<ForceNode> fy = new QuadTree.ValueFunction<ForceNode>(){

        @Override
        public double getValue(ForceNode node, int index) {
            return node.y;
        }
    };

    public Force() {
        final Force self = this;
        this.drag = new ForceDrag(){

            @Override
            public Object run(Selector context, Object ... args) {
                if (args == null || args.length == 0) {
                    return this.drag();
                }
                this.drag((Selector)args[0]);
                return null;
            }

            @Override
            public Drag drag() {
                self.createDrag();
                return self.mdrag;
            }

            @Override
            public void drag(Selector s) {
                self.createDrag();
                s.on("mouseover.force", mouseover).on("mouseout.force", mouseout).call((RunFunction)self.mdrag, new Object[0]);
            }
        };
        this.dragmove = new RunFunction<SceneNode>(){

            @Override
            public Object run(SceneNode context, Object ... args) {
                ForceNode d = (ForceNode)args[0];
                d.px = ((Drag.EventObject)EventTracker.INSTANCE.get()).x;
                d.py = ((Drag.EventObject)EventTracker.INSTANCE.get()).y;
                self.resume();
                return null;
            }
        };
    }

    private QuadTree.Visitor<ForceNode> repulse(final @SwiftWeak ForceNode node) {
        final Force self = this;
        return new QuadTree.Visitor<ForceNode>(){

            @Override
            public boolean visit(QuadTree.QTNode<ForceNode> quad, double x1, double y1, double x2, double y2) {
                ForceNode n = node;
                QuadNodeData fn = (QuadNodeData)quad.data;
                if (quad.point != n) {
                    double dx = fn.cx - n.x;
                    double dy = fn.cy - n.y;
                    double dw = x2 - x1;
                    double dn = dx * dx + dy * dy;
                    if (dw * dw / self.theta2 < dn) {
                        if (dn < self.chargeDistance2) {
                            double k = fn.charge / dn;
                            n.px -= dx * k;
                            n.py -= dy * k;
                        }
                        return true;
                    }
                    if (quad.point != null && dn != 0.0 && dn < self.chargeDistance2) {
                        double k = fn.pointCharge / dn;
                        n.px -= dx * k;
                        n.py -= dy * k;
                    }
                }
                return fn.charge == 0.0;
            }
        };
    }

    public boolean tick() {
        ForceNode on;
        double k;
        double y;
        double x;
        int i;
        double d;
        this.malpha *= 0.99;
        if (d < 0.005) {
            this.malpha = 0.0;
            EventObject eo = new EventObject("end", 0.0);
            ((Dispatcher.DispatcherEvent)this.event.get(eo.type)).fire(eo, eo);
            return true;
        }
        int n = this.mnodes.size();
        int m = this.mlinks.length;
        for (i = 0; i < m; ++i) {
            ForceLink ol = this.mlinks[i];
            ForceNode s = ol.source;
            ForceNode t = ol.target;
            x = t.x - s.x;
            y = t.y - s.y;
            double l = x * x + y * y;
            if (l == 0.0) continue;
            l = Math.sqrt(l);
            l = this.malpha * this.strengths[i] * (l - this.distances[i]) / l;
            k = (double)s.weight / (double)(t.weight + s.weight);
            t.x -= (x *= l) * k;
            t.y -= (y *= l) * k;
            k = 1.0 - k;
            s.x += x * k;
            s.y += y * k;
        }
        k = this.malpha * this.mgravity;
        if (k != 0.0) {
            x = this.msize.getWidth() / 2.0;
            y = this.msize.getHeight() / 2.0;
            i = -1;
            if (k != 0.0) {
                while (++i < n) {
                    on = this.mnodes.get(i);
                    on.x += (x - on.x) * k;
                    on.y += (y - on.y) * k;
                }
            }
        }
        if (ObjectConverter.toBoolean(this.mcharge)) {
            QuadTree.RootQTNode<ForceNode> q = this.quadTree.size(null).quadtree(this.mnodes);
            Force.forceAccumulate(q, this.malpha, this.charges);
            i = -1;
            while (++i < n) {
                on = this.mnodes.get(i);
                if (on.fixed > 0) continue;
                q.visit(this.repulse(on));
            }
        }
        i = -1;
        while (++i < n) {
            on = this.mnodes.get(i);
            if (on.fixed > 0) {
                on.x = on.px;
                on.y = on.py;
                continue;
            }
            on.px = on.x;
            on.x -= (on.px - on.px) * this.mfriction;
            on.py = on.y;
            on.y -= (on.py - on.py) * this.mfriction;
        }
        EventObject eo = new EventObject("tick", this.malpha);
        ((Dispatcher.DispatcherEvent)this.event.get(eo.type)).fire(eo, eo);
        return false;
    }

    public ForceNode[] nodes() {
        return (ForceNode[])this.mnodes.toArray();
    }

    public Force nodes(List<ForceNode> nodes) {
        this.mnodes = nodes;
        return this;
    }

    public ForceLink[] links() {
        return this.mlinks;
    }

    public Force links(ForceLink[] l) {
        this.mlinks = l;
        return this;
    }

    public Dim size() {
        return this.msize;
    }

    public Force size(Dim s) {
        this.msize = s;
        return this;
    }

    public Object distance() {
        return this.linkDistance();
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public Force distance(Object d) {
        return this.linkDistance(d);
    }

    public Object linkDistance() {
        return this.mlinkDistance;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public Force linkDistance(Object x) {
        this.mlinkDistance = x instanceof ValueFunction ? x : Double.valueOf(ObjectConverter.toDouble(x));
        return this;
    }

    public Object linkStrength() {
        return this.mlinkStrength;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public Force linkStrength(Object x) {
        this.mlinkStrength = x instanceof ValueFunction ? x : Double.valueOf(ObjectConverter.toDouble(x));
        return this;
    }

    public double friction() {
        return this.mfriction;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public Force friction(Object f) {
        this.mfriction = ObjectConverter.toDouble(f);
        return this;
    }

    public Object charge() {
        return this.mcharge;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public Force charge(Object x) {
        this.mcharge = x instanceof ValueFunction ? x : Double.valueOf(ObjectConverter.toDouble(x));
        return this;
    }

    public double chargeDistance() {
        return Math.sqrt(this.chargeDistance2);
    }

    public Force chargeDistance(double x) {
        this.chargeDistance2 = x * x;
        return this;
    }

    public double gravity() {
        return this.mgravity;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public Force gravity(Object g) {
        this.mgravity = ObjectConverter.toDouble(g);
        return this;
    }

    public double theta() {
        return Math.sqrt(this.theta2);
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public Force theta(Object x) {
        double xx = ObjectConverter.toDouble(x);
        this.theta2 = xx * xx;
        return this;
    }

    public double alpha() {
        return this.malpha;
    }

    public Force alpha(double x) {
        if (this.malpha != 0.0) {
            this.malpha = x > 0.0 ? x : 0.0;
        } else if (x > 0.0) {
            this.malpha = x;
            EventObject eo = new EventObject("start", x);
            ((Dispatcher.DispatcherEvent)this.event.get(eo.type)).fire(eo, eo);
            final Force force = this;
            Timer.INSTANCE.addEvent(new TimerEvent(){

                @Override
                public boolean run(double elapsed) {
                    return force.tick();
                }
            });
        }
        return this;
    }

    public Force start() {
        ForceNode node;
        int n = this.mnodes.size();
        int m = this.mlinks.length;
        double w = this.msize.getWidth();
        double h = this.msize.getHeight();
        int i = 0;
        while (i < n) {
            node = this.mnodes.get(i);
            node.index = i++;
            node.weight = 0;
        }
        for (i = 0; i < m; ++i) {
            ForceLink link = this.mlinks[i];
            ForceNode source = link.source;
            ForceNode target = link.target;
            if (Lang.isNumber(source)) {
                link.source = this.mnodes.get(ObjectConverter.toInt(source));
            }
            if (Lang.isNumber(target)) {
                link.target = this.mnodes.get(ObjectConverter.toInt(target));
            }
            ++link.source.weight;
            ++link.target.weight;
        }
        for (i = 0; i < n; ++i) {
            node = this.mnodes.get(i);
            if (ObjectConverter.isNaN(node.x)) {
                node.x = this.position(true, w, i);
            }
            if (ObjectConverter.isNaN(node.y)) {
                node.y = this.position(false, h, i);
            }
            if (ObjectConverter.isNaN(node.px)) {
                node.px = node.x;
            }
            if (!ObjectConverter.isNaN(node.py)) continue;
            node.py = node.y;
        }
        this.distances = new double[m];
        if (this.mlinkDistance instanceof ValueFunction) {
            for (i = 0; i < m; ++i) {
                this.distances[i] = ObjectConverter.toDouble(((ValueFunction)this.mlinkDistance).getValue(this, this.mlinks[i], i, -1));
            }
        } else {
            for (i = 0; i < m; ++i) {
                this.distances[i] = ObjectConverter.asDouble(this.mlinkDistance);
            }
        }
        this.strengths = new double[m];
        if (this.mlinkStrength instanceof ValueFunction) {
            for (i = 0; i < m; ++i) {
                this.strengths[i] = ObjectConverter.toDouble(((ValueFunction)this.mlinkStrength).getValue(this, this.mlinks[i], i, -1));
            }
        } else {
            for (i = 0; i < m; ++i) {
                this.strengths[i] = ObjectConverter.asDouble(this.mlinkStrength);
            }
        }
        this.charges = new double[n];
        if (this.mcharge instanceof ValueFunction) {
            for (i = 0; i < n; ++i) {
                this.charges[i] = ObjectConverter.toDouble(((ValueFunction)this.mcharge).getValue(this, this.mnodes.get(i), i, -1));
            }
        } else {
            for (i = 0; i < n; ++i) {
                this.charges[i] = ((Number)this.mcharge).doubleValue();
            }
        }
        return this.resume();
    }

    private double position(boolean xdim, double size, int i) {
        return Random.INSTANCE.randomizer().randomize() * size;
    }

    public Force resume() {
        return this.alpha(0.1);
    }

    public Force stop() {
        return this.alpha(0.0);
    }

    private static void forceAccumulate(QuadTree.QTNode<ForceNode> quad, double alpha, double[] charges) {
        double cx = 0.0;
        double cy = 0.0;
        QuadNodeData fn = new QuadNodeData();
        quad.data = fn;
        fn.charge = 0.0;
        if (!quad.leaf) {
            QuadTree.QTNode<T>[] nodes = quad.nodes;
            double n = nodes.length;
            int i = -1;
            while ((double)(++i) < n) {
                QuadTree.QTNode<ForceNode> c = nodes[i];
                if (c == null) continue;
                Force.forceAccumulate(c, alpha, charges);
                QuadNodeData cfn = (QuadNodeData)c.data;
                fn.charge += cfn.charge;
                cx += cfn.charge * cfn.cx;
                cy += cfn.charge * cfn.cy;
            }
        }
        if (quad.point != null) {
            double k;
            ForceNode n = (ForceNode)quad.point;
            if (!quad.leaf) {
                n.x += Random.INSTANCE.randomizer().randomize() - 0.5;
                n.y += Random.INSTANCE.randomizer().randomize() - 0.5;
            }
            fn.pointCharge = k = alpha * charges[n.index];
            fn.charge += fn.pointCharge;
            cx += k * n.x;
            cy += k * n.y;
        }
        fn.cx = cx / fn.charge;
        fn.cy = cy / fn.charge;
    }

    public RunFunction<? super EventObject> on(String type) {
        return this.event.on(type);
    }

    public Force on(String type, RunFunction<EventObject> listener) {
        this.event.on(type, listener);
        return this;
    }

    private void createDrag() {
        if (this.mdrag == null) {
            this.mdrag = Behavior.INSTANCE.drag().origin(identity).on("dragstart.force", dragstart).on("drag.force", this.dragmove).on("dragend.force", dragend);
        }
    }

    private static final class QuadNodeData {
        double cx;
        double cy;
        double charge;
        double pointCharge;

        private QuadNodeData() {
        }
    }

    public static final class EventObject {
        public final String type;
        public final double alpha;

        EventObject(String type, double alpha) {
            this.type = type;
            this.alpha = alpha;
        }
    }

    public static interface ForceDrag
    extends RunFunction<Selector> {
        public void drag(Selector var1);

        public Drag drag();
    }
}

