/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.layout.force;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.layout.force.ForceLink;
import com.ibm.rave.core.layout.force.ForceNode;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import java.util.List;

public final class ForceData {
    public final List<ForceNode> nodes;
    public final ForceLink[] links;

    private ForceData(List<ForceNode> nodes, ForceLink[] links) {
        this.nodes = nodes;
        this.links = links;
    }

    public static ForceData fromJSON(JSONArray jnodes, JSONArray jlinks) {
        int i;
        int n = jnodes.size();
        int m = jlinks.size();
        ArrayEx<ForceNode> nodes = new ArrayEx<ForceNode>();
        ForceLink[] links = new ForceLink[m];
        for (i = 0; i < n; ++i) {
            Number py;
            Number px;
            Number y;
            ForceNode node = new ForceNode();
            nodes.add(i, node);
            JSONObject jnode = (JSONObject)jnodes.get(i);
            node.data = jnode;
            node.index = i;
            jnode.put((Object)"index", (Object)i);
            Number x = (Number)jnode.get((Object)"x");
            if (x != null) {
                node.x = ObjectConverter.asDouble(x);
            }
            if ((y = (Number)jnode.get((Object)"y")) != null) {
                node.y = ObjectConverter.asDouble(y);
            }
            if ((px = (Number)jnode.get((Object)"px")) != null) {
                node.px = ObjectConverter.asDouble(px);
            }
            if ((py = (Number)jnode.get((Object)"py")) == null) continue;
            node.py = ObjectConverter.asDouble(py);
        }
        for (i = 0; i < m; ++i) {
            ForceLink link;
            links[i] = link = new ForceLink();
            JSONObject jlink = (JSONObject)jlinks.get(i);
            link.data = jlink;
            Object source = jlink.get((Object)"source");
            Object target = jlink.get((Object)"target");
            link.source = Lang.isNumber(source) ? (ForceNode)nodes.get(ObjectConverter.toInt(source)) : (ForceNode)nodes.get(ObjectConverter.toInt(((JSONObject)source).get((Object)"index")));
            link.target = Lang.isNumber(target) ? (ForceNode)nodes.get(ObjectConverter.toInt(target)) : (ForceNode)nodes.get(ObjectConverter.toInt(((JSONObject)target).get((Object)"index")));
            ++link.source.weight;
            ++link.target.weight;
        }
        return new ForceData(nodes, links);
    }
}

