/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.layout.hierarchy;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.layout.hierarchy.HierarchyBase;
import com.ibm.rave.core.layout.hierarchy.HierarchyLink;
import com.ibm.rave.core.layout.hierarchy.HierarchyNode;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import java.util.ArrayList;
import java.util.List;

public final class HierarchyUtil {
    public static <T extends HierarchyNode<T>> T fromJSON(JSONObject root, HierarchyNodeFactory<T> factory) {
        return HierarchyUtil.fromJSON(root, "value", "children", factory);
    }

    public static <T extends HierarchyNode<T>> T fromJSON(JSONObject root, String valueKey, String childrenKey, HierarchyNodeFactory<T> factory) {
        T node = factory.createNode();
        ((HierarchyNode)node).data = root;
        ((HierarchyNode)node).value = ObjectConverter.toDouble(root.get((Object)valueKey));
        Object childrenObj = root.get((Object)childrenKey);
        if (childrenObj instanceof JSONArray) {
            JSONArray children = (JSONArray)childrenObj;
            ArrayEx<T> childNodes = new ArrayEx<T>();
            for (Object child : children) {
                if (!(child instanceof JSONObject)) continue;
                childNodes.add(HierarchyUtil.fromJSON((JSONObject)child, valueKey, childrenKey, factory));
            }
            ((HierarchyNode)node).children = childNodes;
        }
        return node;
    }

    public static <T extends HierarchyNode<T>, S extends HierarchyBase<T, S>> T revalue(T root, final S hierarchy) {
        if (hierarchy.value() != null) {
            HierarchyUtil.visitBefore(root, new Visitor<T>(){

                @Override
                public void visit(T node) {
                    if (((HierarchyNode)node).children != null) {
                        ((HierarchyNode)node).value = 0.0;
                    }
                }
            });
            HierarchyUtil.visitAfter(root, new Visitor<T>(){

                @Override
                public void visit(T node) {
                    Object parent;
                    if (((HierarchyNode)node).children == null) {
                        ((HierarchyNode)node).value = ObjectConverter.toDouble(hierarchy.value().get(hierarchy, node, ((HierarchyNode)node).depth));
                    }
                    if ((parent = ((HierarchyNode)node).parent) != null) {
                        ((HierarchyNode)parent).value += ((HierarchyNode)node).value;
                    }
                }
            });
        }
        return root;
    }

    public static <T extends HierarchyNode<T>> void visitBefore(T node, Visitor<T> callback) {
        Object _node = node;
        ArrayEx<HierarchyNode> nodes = new ArrayEx<HierarchyNode>();
        nodes.add((HierarchyNode)_node);
        while ((_node = (HierarchyNode)nodes.pop()) != null) {
            callback.visit(_node);
            int n = 0;
            ArrayEx children = _node.children;
            if (children == null || (n = children.size()) <= 0) continue;
            while (--n >= 0) {
                nodes.push((HierarchyNode)children.get(n));
            }
        }
    }

    public static <T extends HierarchyNode<T>> void visitAfter(T node, Visitor<T> callback) {
        Object _node = node;
        ArrayEx<HierarchyNode> nodes = new ArrayEx<HierarchyNode>();
        ArrayEx<HierarchyNode> nodes2 = new ArrayEx<HierarchyNode>();
        nodes.add((HierarchyNode)_node);
        while ((_node = (HierarchyNode)nodes.pop()) != null) {
            nodes2.push(_node);
            int n = 0;
            ArrayEx children = _node.children;
            if (children == null || (n = children.size()) <= 0) continue;
            int i = -1;
            while (++i < n) {
                nodes.push((HierarchyNode)children.get(i));
            }
        }
        while ((_node = (HierarchyNode)nodes2.pop()) != null) {
            callback.visit(_node);
        }
    }

    static <T extends HierarchyNode<T>> List<HierarchyLink<T>> links(List<T> nodes) {
        ArrayList<HierarchyLink<T>> links = new ArrayList<HierarchyLink<T>>();
        int num_nodes = nodes.size();
        for (int z = 0; z < num_nodes; ++z) {
            HierarchyNode node = (HierarchyNode)nodes.get(z);
            if (node == null || node.children == null) continue;
            int num_children = node.children.size();
            while (--num_children >= 0) {
                HierarchyLink link = new HierarchyLink();
                link.source = node;
                link.target = node.children.get(num_children);
                links.add(link);
            }
        }
        return links;
    }

    @SwiftClosure(value="visit")
    public static interface Visitor<T extends HierarchyNode<T>> {
        public void visit(T var1);
    }

    @FunctionClass(value="createNode")
    @SwiftClosure(value="createNode")
    public static interface HierarchyNodeFactory<T extends HierarchyNode<T>> {
        public T createNode();
    }
}

