/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.layout.tree;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.layout.hierarchy.HierarchyBase;
import com.ibm.rave.core.layout.hierarchy.HierarchyNode;
import com.ibm.rave.core.layout.hierarchy.HierarchyUtil;
import com.ibm.rave.core.layout.tree.TreeNode;

public class Tree
extends HierarchyBase<TreeNode, Tree> {
    private final GetSeparation<TreeNode> defaultSeparationFunction = new GetSeparation<TreeNode>(){

        @Override
        public int treeSeparation(TreeNode a, TreeNode b) {
            return Tree.treeSeparation(a, b);
        }
    };
    private final HierarchyUtil.Visitor<TreeNode> sizeNode;
    private final HierarchyUtil.Visitor<TreeNodeWrapper> firstWalk;
    private final HierarchyUtil.Visitor<TreeNodeWrapper> secondWalk;
    private boolean _nodeSize = false;
    private ArrayEx<Double> _size = new ArrayEx<Double>(1.0, 1.0);
    private GetSeparation<TreeNode> separationFunction = this.defaultSeparationFunction;

    public Tree() {
        final Tree self = this;
        this.sizeNode = new HierarchyUtil.Visitor<TreeNode>(){

            @Override
            public void visit(TreeNode node) {
                node.x *= ((Double)self._size.get(0)).doubleValue();
                node.y = (double)node.depth * (Double)self._size.get(1);
            }
        };
        this.firstWalk = new HierarchyUtil.Visitor<TreeNodeWrapper>(){

            @Override
            public void visit(TreeNodeWrapper v) {
                TreeNodeWrapper w;
                ArrayEx children = v.children;
                ArrayEx siblings = ((TreeNodeWrapper)v.parent).children;
                TreeNodeWrapper treeNodeWrapper = w = v.i != 0 ? (TreeNodeWrapper)siblings.get(v.i - 1) : null;
                if (children.length() > 0) {
                    self.treeShift(v);
                    double midpoint = (((TreeNodeWrapper)children.get((int)0)).z + ((TreeNodeWrapper)children.get((int)(children.length() - 1))).z) / 2.0;
                    if (w != null) {
                        v.z = w.z + (double)self.separationFunction.treeSeparation(v.wrappedNode, w.wrappedNode);
                        v.m = v.z - midpoint;
                    } else {
                        v.z = midpoint;
                    }
                } else if (w != null) {
                    v.z = w.z + (double)self.separationFunction.treeSeparation(v.wrappedNode, w.wrappedNode);
                }
                ((TreeNodeWrapper)v.parent).A = self.apportion(v, w, ((TreeNodeWrapper)v.parent).A != null ? ((TreeNodeWrapper)v.parent).A : (siblings.size() > 0 ? (TreeNodeWrapper)siblings.get(0) : null));
            }
        };
        this.secondWalk = new HierarchyUtil.Visitor<TreeNodeWrapper>(){

            @Override
            public void visit(TreeNodeWrapper v) {
                v.wrappedNode.x = v.z + ((TreeNodeWrapper)v.parent).m;
                v.m += ((TreeNodeWrapper)v.parent).m;
            }
        };
        this.sort(null);
        this.value(null);
    }

    private TreeNodeWrapper createTreeNodeWrapper(TreeNode treeNode, TreeNodeWrapper parent, int i) {
        TreeNodeWrapper node = new TreeNodeWrapper();
        node.wrappedNode = treeNode;
        node.parent = parent;
        node.children = new ArrayEx();
        node.A = null;
        node.a = node;
        node.z = 0.0;
        node.m = 0.0;
        node.c = 0.0;
        node.s = 0.0;
        node.t = null;
        node.i = i;
        return node;
    }

    private void buildChildren(TreeNodeWrapper node) {
        if (node.wrappedNode.children != null) {
            int n = node.wrappedNode.children.length();
            for (int j = 0; j < n; ++j) {
                TreeNode childTreeNode = (TreeNode)node.wrappedNode.children.get(j);
                TreeNodeWrapper child = this.createTreeNodeWrapper(childTreeNode, node, j);
                node.children.add(child);
                this.buildChildren(child);
            }
        }
    }

    private TreeNodeWrapper wrapTree(TreeNode root0) {
        TreeNodeWrapper rootParent = this.createTreeNodeWrapper(null, null, -1);
        TreeNodeWrapper wrappedRoot0 = this.createTreeNodeWrapper(root0, rootParent, 0);
        wrappedRoot0.rootParent = rootParent;
        this.buildChildren(wrappedRoot0);
        return wrappedRoot0;
    }

    private TreeNodeWrapper apportion(TreeNodeWrapper v, TreeNodeWrapper w, TreeNodeWrapper ancestor) {
        TreeNodeWrapper _ancestor = ancestor;
        if (w != null) {
            TreeNodeWrapper vip = v;
            TreeNodeWrapper vop = v;
            TreeNodeWrapper vim = w;
            TreeNodeWrapper vom = (TreeNodeWrapper)((TreeNodeWrapper)vip.parent).children.get(0);
            double sip = vip.m;
            double sop = vop.m;
            double sim = vim.m;
            double som = vom.m;
            vim = this.treeRight(vim);
            vip = this.treeLeft(vip);
            while (vim != null && vip != null) {
                vom = this.treeLeft(vom);
                vop = this.treeRight(vop);
                vop.a = v;
                double shift = vim.z + sim - vip.z - sip + (double)this.separationFunction.treeSeparation(vim.wrappedNode, vip.wrappedNode);
                if (shift > 0.0) {
                    this.treeMove(this.treeAncestor(vim, v, _ancestor), v, shift);
                    sip += shift;
                    sop += shift;
                }
                sim += vim.m;
                sip += vip.m;
                som += vom.m;
                sop += vop.m;
                vim = this.treeRight(vim);
                vip = this.treeLeft(vip);
            }
            if (vim != null && this.treeRight(vop) == null) {
                vop.t = vim;
                vop.m += sim - sop;
            }
            if (vip != null && this.treeLeft(vom) == null) {
                vom.t = vip;
                vom.m += sip - som;
                _ancestor = v;
            }
        }
        return _ancestor;
    }

    private TreeNodeWrapper treeLeft(TreeNodeWrapper v) {
        ArrayEx children = v.children;
        return children.length() > 0 ? (TreeNodeWrapper)children.get(0) : v.t;
    }

    private TreeNodeWrapper treeRight(TreeNodeWrapper v) {
        ArrayEx children = v.children;
        int n = children.length();
        return n > 0 ? (TreeNodeWrapper)children.get(n - 1) : v.t;
    }

    private void treeMove(TreeNodeWrapper wm, TreeNodeWrapper wp, double shift) {
        double change = shift / (double)(wp.i - wm.i);
        wp.c -= change;
        wp.s += shift;
        wm.c += change;
        wp.z += shift;
        wp.m += shift;
    }

    private void treeShift(TreeNodeWrapper v) {
        double shift = 0.0;
        double change = 0.0;
        ArrayEx children = v.children;
        int i = children.length();
        while (--i >= 0) {
            TreeNodeWrapper w = (TreeNodeWrapper)children.get(i);
            w.z += shift;
            w.m += shift;
            shift += w.s + (change += w.c);
        }
    }

    private TreeNodeWrapper treeAncestor(TreeNodeWrapper vim, TreeNodeWrapper v, TreeNodeWrapper ancestor) {
        return vim.a.parent == v.parent ? vim.a : ancestor;
    }

    @Override
    public ArrayEx<TreeNode> create(TreeNode d) {
        ArrayEx<TreeNode> nodes = super.create(d);
        TreeNode root0 = (TreeNode)nodes.get(0);
        TreeNodeWrapper root1 = this.wrapTree(root0);
        HierarchyUtil.visitAfter(root1, this.firstWalk);
        ((TreeNodeWrapper)root1.parent).m = -root1.z;
        HierarchyUtil.visitBefore(root1, this.secondWalk);
        if (this._nodeSize) {
            HierarchyUtil.visitBefore(root0, this.sizeNode);
        } else {
            final TreeNode[] left = new TreeNode[]{root0};
            final TreeNode[] right = new TreeNode[]{root0};
            final TreeNode[] bottom = new TreeNode[]{root0};
            HierarchyUtil.visitBefore(root0, new HierarchyUtil.Visitor<TreeNode>(){

                @Override
                public void visit(TreeNode node) {
                    if (node.x < left[0].x) {
                        left[0] = node;
                    }
                    if (node.x > right[0].x) {
                        right[0] = node;
                    }
                    if (node.depth > bottom[0].depth) {
                        bottom[0] = node;
                    }
                }
            });
            final double tx = (double)this.separationFunction.treeSeparation(left[0], right[0]) / 2.0 - left[0].x;
            final double kx = (Double)this._size.get(0) / (right[0].x + (double)this.separationFunction.treeSeparation(right[0], left[0]) / 2.0 + tx);
            final double ky = (Double)this._size.get(1) / (double)(bottom[0].depth > 0 ? bottom[0].depth : 1);
            HierarchyUtil.visitBefore(root0, new HierarchyUtil.Visitor<TreeNode>(){

                @Override
                public void visit(TreeNode node) {
                    node.x = (node.x + tx) * kx;
                    node.y = (double)node.depth * ky;
                }
            });
        }
        return nodes;
    }

    public static int treeSeparation(HierarchyNode<?> a, HierarchyNode<?> b) {
        return a.parent == b.parent ? 1 : 2;
    }

    public Tree separation(GetSeparation<TreeNode> func) {
        this.separationFunction = func;
        return this;
    }

    public GetSeparation<TreeNode> separation() {
        return this.separationFunction;
    }

    public Tree size(ArrayEx<Double> sizes) {
        this._size = sizes;
        this._nodeSize = this._size == null;
        return this;
    }

    public ArrayEx<Double> size() {
        return this._nodeSize ? null : this._size;
    }

    public Tree nodeSize(ArrayEx<Double> sizes) {
        this._size = sizes;
        this._nodeSize = this._size != null;
        return this;
    }

    public ArrayEx<Double> nodeSize() {
        return this._nodeSize ? this._size : null;
    }

    @FunctionClass(value="treeSeparation", contextInvocation=false)
    @SwiftClosure(value="treeSeparation")
    public static interface GetSeparation<T extends HierarchyNode<T>> {
        public int treeSeparation(T var1, T var2);
    }

    private static final class TreeNodeWrapper
    extends HierarchyNode<TreeNodeWrapper> {
        @SwiftWeak
        TreeNode wrappedNode;
        TreeNodeWrapper rootParent;
        TreeNodeWrapper A;
        @SwiftWeak
        TreeNodeWrapper a;
        TreeNodeWrapper t;
        int i;
        double z;
        double m;
        double c;
        double s;

        private TreeNodeWrapper() {
        }
    }
}

