/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.layout.treemap;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.functions.TwoParamValueFunction;
import com.ibm.rave.core.internal.layout.treemap.Row;
import com.ibm.rave.core.internal.layout.treemap.TreemapRect;
import com.ibm.rave.core.layout.hierarchy.HierarchyBase;
import com.ibm.rave.core.layout.hierarchy.HierarchyUtil;
import com.ibm.rave.core.layout.treemap.TreemapNode;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import java.util.List;

public class Treemap
extends HierarchyBase<TreemapNode, Treemap> {
    private final SingleValueFunction<TreemapRect, TreemapNode> treemapPadNull = new SingleValueFunction<TreemapRect, TreemapNode>(){

        @Override
        public TreemapRect getValue(TreemapNode node) {
            TreemapRect rect = new TreemapRect();
            rect.x = node.x;
            rect.y = node.y;
            rect.dx = node.dx;
            rect.dy = node.dy;
            return rect;
        }
    };
    private final TwoParamValueFunction<TreemapRect, TreemapNode, List<Double>> treemapPad = new TwoParamValueFunction<TreemapRect, TreemapNode, List<Double>>(){

        @Override
        public TreemapRect getValue(TreemapNode node, List<Double> padding) {
            TreemapRect rect = new TreemapRect();
            rect.x = node.x + ObjectConverter.toDouble(padding.get(3));
            rect.y = node.y + ObjectConverter.toDouble(padding.get(0));
            rect.dx = node.dx - ObjectConverter.toDouble(padding.get(1)) - ObjectConverter.toDouble(padding.get(3));
            rect.dy = node.dy - ObjectConverter.toDouble(padding.get(0)) - ObjectConverter.toDouble(padding.get(2));
            if (rect.dx < 0.0) {
                rect.x += rect.dx / 2.0;
                rect.dx = 0.0;
            }
            if (rect.dy < 0.0) {
                rect.y += rect.dy / 2.0;
                rect.dy = 0.0;
            }
            return rect;
        }
    };
    private boolean _round = true;
    private List<Integer> _size = new ArrayEx<Integer>(1, 1);
    private Object _padding = null;
    private SingleValueFunction<TreemapRect, TreemapNode> _pad = this.treemapPadNull;
    private boolean _sticky = false;
    private ArrayEx<TreemapNode> _stickies = null;
    private String _mode = "squarify";
    private Double _ratio = 0.5 * (1.0 + Math.sqrt(5.0));
    private ArrayEx.ArrayValueFunction<TreemapNode, TreemapNode> squarify;
    private ArrayEx.ArrayValueFunction<TreemapNode, TreemapNode> stickify;

    public Treemap() {
        final Treemap self = this;
        this.squarify = new ArrayEx.ArrayValueFunction<TreemapNode, TreemapNode>(){

            @Override
            public TreemapNode getValue(TreemapNode node, int index, ArrayEx<TreemapNode> array) {
                block5: {
                    int n;
                    ArrayEx children = node.children;
                    if (children == null || children.size() == 0) break block5;
                    TreemapRect rect = (TreemapRect)self._pad.getValue(node);
                    Row row = new Row();
                    ArrayEx remaining = children.slice();
                    double best = Double.POSITIVE_INFINITY;
                    double score = 0.0;
                    double u = self._mode.equals("slice") ? rect.dx : (self._mode.equals("dice") ? rect.dy : (self._mode.equals("slice-dice") ? (ObjectConverter.toBoolean(node.depth & 1) ? rect.dy : rect.dx) : Math.min(rect.dx, rect.dy)));
                    self.scale(remaining, rect.dx * rect.dy / node.value);
                    row.area = 0.0;
                    while ((n = remaining.size()) > 0) {
                        block7: {
                            block6: {
                                double d;
                                TreemapNode child = (TreemapNode)remaining.get(n - 1);
                                row.push(child);
                                row.area += child.area;
                                if (!self._mode.equals("squarify")) break block6;
                                score = self.worst(row, u);
                                if (!(d <= best)) break block7;
                            }
                            remaining.pop();
                            best = score;
                            continue;
                        }
                        row.area -= ((TreemapNode)row.pop()).area;
                        self.position(row, u, rect, false);
                        u = Math.min(rect.dx, rect.dy);
                        row = new Row();
                        best = Double.POSITIVE_INFINITY;
                    }
                    if (row.length() != 0) {
                        self.position(row, u, rect, true);
                        row = new Row();
                    }
                    children.forEach(self.squarify);
                }
                return null;
            }
        };
        this.stickify = new ArrayEx.ArrayValueFunction<TreemapNode, TreemapNode>(){

            @Override
            public TreemapNode getValue(TreemapNode node, int index, ArrayEx<TreemapNode> array) {
                ArrayEx children = node.children;
                if (children != null && children.length() != 0) {
                    TreemapNode child;
                    TreemapRect rect = (TreemapRect)self._pad.getValue(node);
                    ArrayEx remaining = children.slice();
                    Row row = new Row();
                    self.scale(remaining, rect.dx * rect.dy / node.value);
                    row.area = 0.0;
                    while ((child = (TreemapNode)remaining.pop()) != null) {
                        row.push(child);
                        row.area += child.area;
                        if (child.z == null) continue;
                        self.position(row, child.z != false ? rect.dx : rect.dy, rect, remaining.length() == 0);
                        row = new Row();
                    }
                    children.forEach(self.stickify);
                }
                return null;
            }
        };
    }

    private void scale(List<TreemapNode> children, double k) {
        int i = -1;
        int n = children.size();
        while (++i < n) {
            TreemapNode child = children.get(i);
            double area = child.value * (k < 0.0 ? 0.0 : k);
            child.area = Double.isNaN(area) || area <= 0.0 ? 0.0 : area;
        }
    }

    private double worst(Row row, double u) {
        double _u = u;
        double s = row.area;
        double rmax = 0.0;
        double rmin = Double.POSITIVE_INFINITY;
        int i = -1;
        int n = row.length();
        while (++i < n) {
            double r = ((TreemapNode)row.get((int)i)).area;
            if (r == 0.0) continue;
            if (r < rmin) {
                rmin = r;
            }
            if (!(r > rmax)) continue;
            rmax = r;
        }
        s *= s;
        _u *= _u;
        return s != 0.0 ? Math.max(_u * rmax * this._ratio / s, s / (_u * rmin * this._ratio)) : Double.POSITIVE_INFINITY;
    }

    private void position(Row row, double u, TreemapRect rect, boolean flush) {
        double v;
        int i = -1;
        int n = row.length();
        double x = rect.x;
        double y = rect.y;
        double d = v = u != 0.0 ? this.roundFunction(row.area / u) : 0.0;
        if (u == rect.dx) {
            TreemapNode o = null;
            if (flush || v > rect.dy) {
                v = rect.dy;
            }
            while (++i < n) {
                o = (TreemapNode)row.get(i);
                o.x = x;
                o.y = y;
                o.dy = v;
                o.dx = Math.min(rect.x + rect.dx - x, v != 0.0 ? this.roundFunction(o.area / v) : 0.0);
                x += o.dx;
            }
            if (o != null) {
                o.z = true;
                o.dx += rect.x + rect.dx - x;
                rect.y += v;
                rect.dy -= v;
            }
        } else {
            TreemapNode o = null;
            if (flush || v > rect.dx) {
                v = rect.dx;
            }
            while (++i < n) {
                o = (TreemapNode)row.get(i);
                o.x = x;
                o.y = y;
                o.dx = v;
                o.dy = Math.min(rect.y + rect.dy - y, v != 0.0 ? this.roundFunction(o.area / v) : 0.0);
                y += o.dy;
            }
            if (o != null) {
                o.z = false;
                o.dy += rect.y + rect.dy - y;
                rect.x += v;
                rect.dx -= v;
            }
        }
    }

    @Override
    public ArrayEx<TreemapNode> create(TreemapNode d) {
        ArrayEx<TreemapNode> nodes = this._stickies != null ? this._stickies : super.create(d);
        TreemapNode root = (TreemapNode)nodes.get(0);
        root.x = 0.0;
        root.y = 0.0;
        root.dx = this._size.get(0).intValue();
        root.dy = this._size.get(1).intValue();
        if (this._stickies != null) {
            HierarchyUtil.revalue(root, this);
        }
        this.scale(new ArrayEx<TreemapNode>(root), root.dx * root.dy / root.value);
        (this._stickies != null ? this.stickify : this.squarify).getValue(root, 0, new ArrayEx<TreemapNode>(root));
        if (this._sticky) {
            this._stickies = nodes;
        }
        return nodes;
    }

    public List<Integer> size() {
        return this._size;
    }

    public Treemap size(List<Integer> size) {
        this._size = size;
        return this;
    }

    public Object padding() {
        return this._padding;
    }

    public Treemap padding(double padding) {
        ArrayEx<Double> paddingArray = new ArrayEx<Double>();
        paddingArray.add(padding);
        return this.padding(paddingArray);
    }

    public Treemap padding(final List<Double> padding) {
        final Treemap self = this;
        SingleValueFunction<TreemapRect, TreemapNode> padConstant = new SingleValueFunction<TreemapRect, TreemapNode>(){

            @Override
            public TreemapRect getValue(TreemapNode node) {
                return (TreemapRect)self.treemapPad.getValue(node, padding.size() == 1 ? new ArrayEx<Double>((Double)padding.get(0), (Double)padding.get(0), (Double)padding.get(0), (Double)padding.get(0)) : padding);
            }
        };
        this._padding = padding;
        this._pad = this._padding == null || padding.size() == 0 ? this.treemapPadNull : padConstant;
        return this;
    }

    public Treemap padding(final TwoParamValueFunction<Object, TreemapNode, Integer> padding) {
        final Treemap self = this;
        SingleValueFunction<TreemapRect, TreemapNode> padFunction = new SingleValueFunction<TreemapRect, TreemapNode>(){

            @Override
            public TreemapRect getValue(TreemapNode node) {
                Object pObject = padding.getValue(node, node.depth);
                ArrayEx<Object> p = null;
                if (pObject instanceof Number) {
                    p = new ArrayEx<Double>(ObjectConverter.toDouble(pObject), ObjectConverter.toDouble(pObject), ObjectConverter.toDouble(pObject), ObjectConverter.toDouble(pObject));
                } else if (pObject instanceof List) {
                    List pList = (List)pObject;
                    p = new ArrayEx();
                    for (Object o : pList) {
                        p.add(o);
                    }
                }
                return p == null ? (TreemapRect)self.treemapPadNull.getValue(node) : (TreemapRect)self.treemapPad.getValue(node, p);
            }
        };
        this._padding = padding;
        this._pad = this._padding == null ? this.treemapPadNull : padFunction;
        return this;
    }

    public boolean round() {
        return this._round;
    }

    public Treemap round(boolean round) {
        this._round = round;
        return this;
    }

    private double roundFunction(Double value) {
        if (this._round) {
            return Math.round(value);
        }
        return value;
    }

    public boolean sticky() {
        return this._sticky;
    }

    public Treemap sticky(boolean sticky) {
        this._sticky = sticky;
        this._stickies = null;
        return this;
    }

    public double ratio() {
        return this._ratio;
    }

    public Treemap ratio(double ratio) {
        this._ratio = ratio;
        return this;
    }

    public String mode() {
        return this._mode;
    }

    public Treemap mode(String mode) {
        this._mode = mode + "";
        return this;
    }
}

