/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.math;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.core.context.RaveContextManager;

public final class Random {
    @InlineStringConstant
    private static final String RANDOMIZER_KEY = "RANDOMIZER_KEY";
    public static final Random INSTANCE = new Random();
    private final Randomizer defaultRandomizerFunc = new Randomizer(){

        @Override
        public double randomize() {
            return Math.random();
        }
    };

    private void setRandomizerFunc(Randomizer randomizer) {
        RaveContextManager.INSTANCE.getRaveContext().putData(RANDOMIZER_KEY, randomizer);
    }

    private Randomizer getRandomizerFunc() {
        if (RaveContextManager.INSTANCE.getRaveContext() == null) {
            return this.defaultRandomizerFunc;
        }
        Randomizer randomizer = (Randomizer)RaveContextManager.INSTANCE.getRaveContext().getData(RANDOMIZER_KEY);
        if (randomizer == null) {
            randomizer = this.defaultRandomizerFunc;
            RaveContextManager.INSTANCE.getRaveContext().putData(RANDOMIZER_KEY, randomizer);
        }
        return randomizer;
    }

    private Random() {
    }

    public Randomizer randomizer() {
        return this.getRandomizerFunc();
    }

    public Randomizer randomizer(Randomizer randomizer) {
        this.setRandomizerFunc(randomizer);
        return randomizer;
    }

    public Randomizer normal() {
        return this.normal(0.0, 1.0);
    }

    public Randomizer normal(double mean) {
        return this.normal(mean, 1.0);
    }

    public Randomizer normal(final double mean, final double deviation) {
        return new Randomizer(){

            @Override
            public double randomize() {
                double y;
                double x;
                double r;
                while ((r = (x = INSTANCE.getRandomizerFunc().randomize() * 2.0 - 1.0) * x + (y = INSTANCE.getRandomizerFunc().randomize() * 2.0 - 1.0) * y) == 0.0 || r > 1.0) {
                }
                return mean + deviation * y * Math.sqrt(-2.0 * Math.log(r) / r);
            }
        };
    }

    public Randomizer logNormal() {
        return this.logNormal(0.0, 1.0);
    }

    public Randomizer logNormal(double mean) {
        return this.logNormal(mean, 1.0);
    }

    public Randomizer logNormal(double mean, double deviation) {
        final Randomizer random = this.normal(mean, deviation);
        return new Randomizer(){

            @Override
            public double randomize() {
                return Math.exp(random.randomize());
            }
        };
    }

    public Randomizer bates(final int count) {
        final Randomizer random = this.irwinHall(count);
        return new Randomizer(){

            @Override
            public double randomize() {
                return random.randomize() / (double)count;
            }
        };
    }

    public Randomizer irwinHall(final int count) {
        return new Randomizer(){

            @Override
            public double randomize() {
                double s = 0.0;
                for (int j = 0; j < count; ++j) {
                    s += INSTANCE.getRandomizerFunc().randomize();
                }
                return s;
            }
        };
    }

    @FunctionClass(value="randomize")
    @SwiftClosure(value="randomize")
    public static interface Randomizer {
        public double randomize();
    }
}

