/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.nativeImpl;

import com.ibm.rave.core.nativeImpl.timer.Timer;
import com.ibm.rave.core.nativeImpl.timer.TimerEvent;
import com.ibm.rave.core.util.Runnable;

public final class EventQueue {
    public static Object setTimeout(Runnable runnable, int delay) {
        RunnableTimerTask timerTask = new RunnableTimerTask(runnable, false);
        Timer.INSTANCE.addEvent(timerTask, delay);
        return timerTask;
    }

    public static void clearTimeout(Object key) {
        if (key instanceof RunnableTimerTask) {
            ((RunnableTimerTask)key).cancel();
        }
    }

    public static Object setInterval(Runnable function, int period) {
        RunnableTimerTask timerTask = new RunnableTimerTask(function, true);
        Timer.INSTANCE.addEvent(timerTask, period);
        return timerTask;
    }

    public static void clearInterval(Object key) {
        if (key instanceof RunnableTimerTask) {
            ((RunnableTimerTask)key).cancel();
        }
    }

    private static class RunnableTimerTask
    implements TimerEvent {
        private final boolean repeating;
        private boolean cancelled;
        private final Runnable runnable;

        RunnableTimerTask(Runnable runnable, boolean repeating) {
            this.runnable = runnable;
            this.repeating = repeating;
        }

        synchronized void cancel() {
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean run(double elapsed) {
            RunnableTimerTask runnableTimerTask = this;
            synchronized (runnableTimerTask) {
                if (this.cancelled) {
                    return true;
                }
            }
            this.runnable.run();
            return !this.repeating;
        }
    }
}

