/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.nativeImpl.arrays;

import com.ibm.rave.core.functions.TwoParamValueFunction;
import com.ibm.rave.core.internal.collections.OMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ES6Map<K, V> {
    private HashMap<K, V> delegate = new HashMap();

    private ES6Map() {
    }

    private ES6Map(Map<K, V> map) {
        if (map != null) {
            this.delegate.putAll(map);
        }
    }

    private ES6Map(OMap<K, V> map) {
        if (map != null) {
            for (K key : map.keySet()) {
                this.delegate.put(key, map.get(key));
            }
        }
    }

    private ES6Map(ES6Map<K, V> map) {
        if (map != null) {
            this.delegate.putAll(map.delegate);
        }
    }

    public static <K, V> ES6Map<K, V> create() {
        return new ES6Map<K, V>();
    }

    public static <K, V> ES6Map<K, V> create(OMap<K, V> map) {
        return new ES6Map<K, V>(map);
    }

    public static <K, V> ES6Map<K, V> create(Map<K, V> map) {
        return new ES6Map<K, V>(map);
    }

    public static <K, V> ES6Map<K, V> create(ES6Map<K, V> map) {
        return new ES6Map<K, V>(map);
    }

    public boolean has(K key) {
        return this.delegate.containsKey(key);
    }

    public V get(K key) {
        return this.delegate.get(key);
    }

    public V set(K key, V value) {
        this.delegate.put(key, value);
        return value;
    }

    public boolean remove(K key) {
        return this.delegate.remove(key) != null;
    }

    public List<K> keys() {
        ArrayList<K> keySet = new ArrayList<K>(this.delegate.keySet());
        return Collections.unmodifiableList(keySet);
    }

    public List<V> values() {
        ArrayList<V> values = new ArrayList<V>(this.delegate.values());
        return Collections.unmodifiableList(values);
    }

    public List<Map.Entry<K, V>> entries() {
        ArrayList<Map.Entry<K, V>> entrySet = new ArrayList<Map.Entry<K, V>>(this.delegate.entrySet());
        return Collections.unmodifiableList(entrySet);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean empty() {
        return this.delegate.isEmpty();
    }

    public void forEach(TwoParamValueFunction<V, K, V> f) {
        for (K key : this.delegate.keySet()) {
            f.getValue(key, this.delegate.get(key));
        }
    }
}

