/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.nativeImpl.dsv;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.context.RaveContextManager;
import com.ibm.rave.core.internal.nativeImpl.RegExp;
import com.ibm.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.rave.core.nativeImpl.dsv.DsvInstance;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;

@FunctionClass(value="create")
public class Dsv {
    @InlineStringConstant
    private static final String DSV_REG_EXP_KEY_PREFIX = "DSV_REG_EXP_KEY_";
    private final String _mimeType;
    private final String _delimiter;
    private final String _regExObjectKey;

    protected Dsv(String delimiter, String mimeType) {
        this._delimiter = delimiter;
        this._mimeType = mimeType;
        this._regExObjectKey = DSV_REG_EXP_KEY_PREFIX + this._delimiter + this._mimeType;
    }

    private RegExp getDsvRegExp() {
        RegExp regexp = (RegExp)RaveContextManager.INSTANCE.getRaveContext().getData(this._regExObjectKey);
        if (regexp == null) {
            regexp = new RegExp("[\"" + this._delimiter + "\n]", "g");
            RaveContextManager.INSTANCE.getRaveContext().putData(this._regExObjectKey, regexp);
        }
        return regexp;
    }

    public <A> void create(String url, Response<A, JSONObject> respFunc, Callback<A> callback) {
        DsvInstance<A> dsvInst = new DsvInstance<A>(this._delimiter);
        dsvInst.loadUrl(url, respFunc, callback);
    }

    public void create(String url, Callback<JSONObject> callback) {
        DsvInstance dsvInst = new DsvInstance(this._delimiter);
        dsvInst.loadUrl(url, callback);
    }

    public <A> ArrayEx<A> parse(String fileContent, Response<A, JSONObject> respFunc) {
        DsvInstance<A> dsvInst = new DsvInstance<A>(this._delimiter);
        return dsvInst.parse(fileContent, respFunc);
    }

    public ArrayEx<JSONObject> parse(String fileContent) {
        DsvInstance dsvInst = new DsvInstance(this._delimiter);
        return dsvInst.parse(fileContent);
    }

    public <A> ArrayEx<A> parseRows(String fileContent, Response<A, ArrayEx<String>> respFunc) {
        DsvInstance<A> dsvInst = new DsvInstance<A>(this._delimiter);
        return dsvInst.parseRows(fileContent, respFunc);
    }

    public ArrayEx<ArrayEx<String>> parseRows(String fileContent) {
        DsvInstance dsvInst = new DsvInstance(this._delimiter);
        return dsvInst.parseRows(fileContent);
    }

    public String format(ArrayEx<JSONObject> rows) {
        int i;
        ES6Map<String, Integer> fieldSet = ES6Map.create();
        ArrayEx<String> fields = new ArrayEx<String>();
        for (int i2 = 0; i2 < rows.length(); ++i2) {
            Object[] keys = ((JSONObject)rows.get(i2)).keySet().toArray();
            for (int j = 0; j < keys.length; ++j) {
                String key = (String)keys[j];
                if (fieldSet.has(key)) continue;
                fieldSet.set(key, new Integer(1));
                fields.push(key);
            }
        }
        String retStr = "";
        for (i = 0; i < fields.length(); ++i) {
            retStr = i > 0 ? retStr + this._delimiter + this.formatValue((String)fields.get(i)) : this.formatValue((String)fields.get(i));
        }
        for (i = 0; i < rows.length(); ++i) {
            retStr = retStr + "\n";
            JSONObject row = (JSONObject)rows.get(i);
            boolean firstDelimiter = true;
            for (int j = 0; j < fields.length(); ++j) {
                String value = ObjectConverter.toString(row.get(fields.get(j)));
                if (!firstDelimiter) {
                    retStr = retStr + this._delimiter;
                }
                firstDelimiter = false;
                if (value == null) continue;
                retStr = retStr + this.formatValue(value);
            }
        }
        return retStr;
    }

    public String formatRows(ArrayEx<ArrayEx<String>> rows) {
        String retStr = "";
        for (int i = 0; i < rows.length(); ++i) {
            if (i > 0) {
                retStr = retStr + "\n";
            }
            retStr = retStr + this.formatRow((ArrayEx)rows.get(i));
        }
        return retStr;
    }

    protected String formatRow(ArrayEx<String> row) {
        String retStr = "";
        for (int i = 0; i < row.length(); ++i) {
            if (i > 0) {
                retStr = retStr + this._delimiter;
            }
            retStr = retStr + this.formatValue((String)row.get(i));
        }
        return retStr;
    }

    public String formatValue(String text) {
        String retStr;
        RegExp reFormat = this.getDsvRegExp();
        reFormat.lastIndex = 0;
        String string = retStr = reFormat.test(text) ? "\"" + text.replaceAll("\\\"", "\"\"") + "\"" : text;
        if (retStr == null || "null".equals(retStr)) {
            return "";
        }
        return retStr;
    }

    @FunctionClass(value="response")
    public static interface Response<A, B> {
        public A response(B var1, int var2);
    }

    @FunctionClass(value="callback")
    public static interface Callback<A> {
        public void callback(ArrayEx<A> var1);
    }
}

