/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.scales;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.ValueFunction;
import java.util.List;

public abstract class AbstractScale<C, R>
implements ValueFunction<C, R> {
    public InvertValueFunction<Object> invert;
    public RangeExtentValueFunction<R> rangeExtent;
    public RangeBandValueFunction rangeBand;
    public TicksValueFunction ticks;
    public TickFormatValueFunction tickFormat;
    public ZoomTransformFunction zoomTransform;
    public TicksInRangeFunction ticksInRange;

    public static ArrayEx<Object> scaleExtent(List<Object> range) {
        Object start = range.get(0);
        Object stop = range.get(range.size() - 1);
        if (start instanceof Number && stop instanceof Number && ObjectConverter.asDouble(start) > ObjectConverter.asDouble(stop)) {
            return new ArrayEx<Object>(stop, start);
        }
        return new ArrayEx<Object>(start, stop);
    }

    public static List<Object> scaleRange(AbstractScale<Object, Object> scale) {
        if (scale.getRangeExtent() != null) {
            return scale.getRangeExtent().getValue();
        }
        return AbstractScale.scaleExtent(scale.range());
    }

    public abstract AbstractScale<C, R> domain(List<R> var1);

    public abstract List<R> domain();

    public abstract AbstractScale<C, R> range(List<R> var1);

    public abstract List<R> range();

    public abstract AbstractScale<C, R> copy();

    public final TickFormatValueFunction getTickFormat() {
        return this.tickFormat;
    }

    public final RangeBandValueFunction getRangeBand() {
        return this.rangeBand;
    }

    public final RangeExtentValueFunction<R> getRangeExtent() {
        return this.rangeExtent;
    }

    public final TicksValueFunction getTicks() {
        return this.ticks;
    }

    public final ZoomTransformFunction getZoomTransform() {
        return this.zoomTransform;
    }

    public final TicksInRangeFunction getTicksInRange() {
        return this.ticksInRange;
    }

    public final InvertValueFunction<Object> getInvert() {
        return this.invert;
    }

    protected final void setInvert(InvertValueFunction<Object> invert) {
        this.invert = invert;
    }

    protected final void setRangeExtent(RangeExtentValueFunction<R> rangeExtent) {
        this.rangeExtent = rangeExtent;
    }

    protected final void setRangeBand(RangeBandValueFunction rangeBand) {
        this.rangeBand = rangeBand;
    }

    protected final void setTicks(TicksValueFunction ticks) {
        this.ticks = ticks;
    }

    protected final void setTickFormat(TickFormatValueFunction tickFormat) {
        this.tickFormat = tickFormat;
    }

    protected final void setZoomTransform(ZoomTransformFunction zoomTransform) {
        this.zoomTransform = zoomTransform;
    }

    protected final void setTicksInRange(TicksInRangeFunction ticksInRange) {
        this.ticksInRange = ticksInRange;
    }

    @Override
    @SwiftMethodOverload(skipParameters={1})
    public abstract R getValue(C var1, Object var2, int var3, int var4);

    @FunctionClass(value="ticksInRange")
    @SwiftClosure(value="ticksInRange")
    public static interface TicksInRangeFunction {
        public ArrayEx<Object> ticksInRange(Object ... var1);
    }

    @FunctionClass(value="zoomTransform")
    @SwiftClosure(value="zoomTransform")
    public static interface ZoomTransformFunction {
        public void zoomTransform(Number var1, Number var2);
    }

    @FunctionClass(value="getValue")
    @SwiftClosure(value="getValue")
    public static interface TickFormatValueFunction {
        public ValueFunction<Object, String> getValue(Object ... var1);
    }

    @FunctionClass(value="getValue")
    @SwiftClosure(value="getValue")
    public static interface TicksValueFunction {
        public ArrayEx<Object> getValue(Object ... var1);
    }

    @FunctionClass(value="getValue")
    @SwiftClosure(value="getValue")
    public static interface RangeBandValueFunction {
        public Number getValue();
    }

    @FunctionClass(value="getValue")
    @SwiftClosure(value="getValue")
    public static interface RangeExtentValueFunction<R> {
        public List<R> getValue();
    }

    @FunctionClass(value="getValue")
    @SwiftClosure(value="getValue")
    public static interface InvertValueFunction<R> {
        public R getValue(R var1);
    }
}

