/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.scales;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.format.FormatPrefix;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.internal.interpolate.UninterpolateClamp;
import com.ibm.rave.core.internal.interpolate.UninterpolateNumber;
import com.ibm.rave.core.internal.nativeImpl.RegExp;
import com.ibm.rave.core.internal.scales.Bilinear;
import com.ibm.rave.core.internal.scales.LinearValueFunction;
import com.ibm.rave.core.internal.scales.Nice;
import com.ibm.rave.core.internal.scales.Polylinear;
import com.ibm.rave.core.interpolate.InterpolatorFactory;
import com.ibm.rave.core.interpolate.RoundInterpolation;
import com.ibm.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.time.ITimeInterval;
import java.util.List;

public class LinearScale
extends AbstractScale<Object, Object> {
    protected static final int DEFAULT_TICKS = 10;
    private ArrayEx<Object> _domain = new ArrayEx<Object>(0, 1);
    private ArrayEx<Object> _range = new ArrayEx<Object>(0, 1);
    protected InterpolatorFactory<Object> _interpolate = Rave.interpolate;
    protected boolean _clamp = false;
    private SingleValueFunction<Object, Object> output;
    protected SingleValueFunction<Object, Object> input;
    private static ES6Map<String, Integer> linearFormatSignificant = LinearScale.initialize_linearFormatSignificant();

    public LinearScale(List<Object> domain, List<Object> range, InterpolatorFactory<Object> interpolate, Boolean clamp) {
        if (domain != null) {
            this.domain((List)domain);
        }
        if (range != null) {
            this.range((List)range);
        }
        if (interpolate != null) {
            this._interpolate = interpolate;
        }
        if (clamp != null) {
            this._clamp = clamp;
        }
        final LinearScale self = this;
        this.setInvert(new AbstractScale.InvertValueFunction<Object>(){

            @Override
            public Object getValue(Object y) {
                return self.input.getValue(y);
            }
        });
        this.setTicks(new AbstractScale.TicksValueFunction(){

            @Override
            public ArrayEx<Object> getValue(Object ... tickArguments) {
                return LinearScale.linearTicks(self._domain, tickArguments);
            }
        });
        this.setTickFormat(new AbstractScale.TickFormatValueFunction(){

            @Override
            public ValueFunction<Object, String> getValue(Object ... tickArguments) {
                Double count = tickArguments.length > 0 ? Double.valueOf(ObjectConverter.toDouble(tickArguments[0])) : null;
                Object format = tickArguments.length > 1 ? tickArguments[1] : null;
                return LinearScale.linearTickFormat(self._domain, count, format instanceof String ? (String)format : null);
            }
        });
        this.rescale();
    }

    private LinearScale rescale() {
        LinearValueFunction linear = Math.min(this._domain.size(), this._range.size()) > 2 ? new Polylinear() : new Bilinear();
        InterpolatorFactory<Object> uninterpolator = this._clamp ? new UninterpolateClamp() : new UninterpolateNumber();
        this.output = linear.getValue(this._domain, this._range, uninterpolator, this._interpolate);
        this.input = linear.getValue(this._range, this._domain, uninterpolator, Rave.interpolate);
        return this;
    }

    @Override
    @SwiftMethodOverload(skipParameters={1})
    public Object getValue(Object context, Object data, int index, int groupIndex) {
        return this.output.getValue(data);
    }

    public LinearScale domain(List<Object> values) {
        this._domain = new ArrayEx();
        for (Object o : values) {
            this._domain.add(ObjectConverter.toDouble(o));
        }
        return this.rescale();
    }

    @Override
    public ArrayEx<Object> domain() {
        return this._domain;
    }

    public LinearScale range(List<Object> values) {
        this._range = new ArrayEx();
        for (Object o : values) {
            this._range.add(o);
        }
        return this.rescale();
    }

    @Override
    public ArrayEx<Object> range() {
        return this._range;
    }

    public LinearScale rangeRound(List<Object> x) {
        return ((LinearScale)this.range((List)x)).interpolate(new RoundInterpolation());
    }

    public LinearScale clamp(boolean c) {
        this._clamp = c;
        return this.rescale();
    }

    public boolean clamp() {
        return this._clamp;
    }

    public LinearScale interpolate(InterpolatorFactory<Object> interpolate) {
        this._interpolate = interpolate;
        return this.rescale();
    }

    public Object interpolate() {
        return this._interpolate;
    }

    public LinearScale nice() {
        LinearScale.linearNice(this._domain, 10);
        return this.rescale();
    }

    public LinearScale nice(Number tickCount) {
        LinearScale.linearNice(this._domain, tickCount);
        return this.rescale();
    }

    public LinearScale nice(Number tickCount, Number magnitidue) {
        if (tickCount == null) {
            tickCount = 10;
        }
        Nice.scaleNice(this._domain, Nice.niceStep(LinearScale.linearTickRange(this._domain, tickCount, magnitidue).get(2)));
        return this.rescale();
    }

    public LinearScale nice(ITimeInterval interval, Number tickCount) {
        return null;
    }

    public LinearScale nice(ITimeInterval interval) {
        return null;
    }

    public LinearScale copy() {
        return new LinearScale(this.domain(), this.range(), this._interpolate, this._clamp);
    }

    static ArrayEx<Object> linearNice(ArrayEx<Object> domain, Number tickArguments) {
        return Nice.scaleNice(domain, Nice.niceStep(LinearScale.linearTickRange(domain, tickArguments).get(2)));
    }

    protected static ArrayEx<Object> linearTickRange(List<Object> domain, Number tickCount, Number magnitude) {
        double m = tickCount != null ? ObjectConverter.asDouble(tickCount) : 10.0;
        ArrayEx<Object> extent = AbstractScale.scaleExtent(domain);
        double span = ObjectConverter.toDouble(extent.get(1)) - ObjectConverter.toDouble(extent.get(0));
        double tickMagnitude = Math.floor(Math.log(span / m) / Math.log(10.0));
        if (magnitude != null) {
            tickMagnitude = Math.max(ObjectConverter.toDouble(magnitude), tickMagnitude);
        }
        return LinearScale.getTickExtent(domain, m, tickMagnitude);
    }

    protected static ArrayEx<Object> linearTickRange(List<Object> domain, Number tickCount) {
        double m = tickCount != null ? ObjectConverter.asDouble(tickCount) : 10.0;
        ArrayEx<Object> extent = AbstractScale.scaleExtent(domain);
        double span = ObjectConverter.toDouble(extent.get(1)) - ObjectConverter.toDouble(extent.get(0));
        Double magnitude = Math.floor(Math.log(span / m) / Math.log(10.0));
        return LinearScale.getTickExtent(domain, m, magnitude);
    }

    private static ArrayEx<Object> getTickExtent(List<Object> domain, double tickCount, double tickMagnitude) {
        double step;
        ArrayEx<Object> extent = AbstractScale.scaleExtent(domain);
        double span = ObjectConverter.toDouble(extent.get(1)) - ObjectConverter.toDouble(extent.get(0));
        double err = tickCount / span * (step = Math.pow(10.0, tickMagnitude));
        if (err <= 0.15) {
            step *= 10.0;
        } else if (err <= 0.35) {
            step *= 5.0;
        } else if (err <= 0.75) {
            step *= 2.0;
        }
        extent.set(0, Math.ceil(ObjectConverter.toDouble(extent.get(0)) / step) * step);
        extent.set(1, Math.floor(ObjectConverter.toDouble(extent.get(1)) / step) * step + step * 0.5);
        extent.add(2, step);
        return extent;
    }

    static ArrayEx<Object> linearTicks(List<Object> domain, Object ... tickArguments) {
        Double tickCount = tickArguments != null && tickArguments.length > 0 ? Double.valueOf(ObjectConverter.toDouble(tickArguments[0])) : null;
        Object magnitude = tickArguments != null && tickArguments.length > 2 ? tickArguments[2] : null;
        ArrayEx<Object> extents = null;
        extents = magnitude == null ? LinearScale.linearTickRange(domain, tickCount) : LinearScale.linearTickRange(domain, tickCount, ObjectConverter.toDouble(magnitude));
        return ObjectConverter.numberArrayAsObjectArray(Rave.range(ObjectConverter.toDouble(extents.get(0)), ObjectConverter.toDouble(extents.get(1)), ObjectConverter.toDouble(extents.get(2))));
    }

    static ValueFunction<Object, String> linearTickFormat(List<Object> domain, Number m, String format) {
        String _format = format;
        ArrayEx<Object> range = LinearScale.linearTickRange(domain, m);
        if (ObjectConverter.toBoolean(_format)) {
            RegExp.RegExpResult match = new RegExp("(?:([^{])?([<>=^]))?([+\\- ])?([$#])?(0)?(\\d+)?(,)?(\\.-?\\d+)?([a-z%])?", "i").exec(_format);
            match.shift();
            if (match.size() >= 8 && ((String)match.get(8)).equals("s")) {
                Double d = Math.max(Math.abs(ObjectConverter.toDouble(range.get(0))), Math.abs(ObjectConverter.toDouble(range.get(1))));
                final FormatPrefix prefix = Rave.formatPrefix(d, null);
                if (!ObjectConverter.toBoolean(match.get(7))) {
                    match.set(7, "." + LinearScale.linearPrecision(prefix.scale.scale(ObjectConverter.toDouble(range.get(2)))));
                }
                match.set(8, "f");
                final ValueFunction<Object, String> numFormat = Rave.format.create(match.join(""));
                return new ValueFunction<Object, String>(){

                    @Override
                    public String getValue(Object context, Object data, int index, int groupIndex) {
                        return (String)numFormat.getValue(context, prefix.scale.scale(ObjectConverter.toDouble(data)), index, groupIndex) + prefix.symbol;
                    }
                };
            }
            if (!ObjectConverter.toBoolean(match.get(7))) {
                match.set(7, "." + LinearScale.linearFormatPrecision((String)match.get(8), range));
            }
            _format = match.join("");
        } else {
            double value = ObjectConverter.toDouble(range.get(2));
            _format = ",." + LinearScale.linearPrecision(value) + "f";
        }
        return Rave.format.create(_format);
    }

    private static ES6Map<String, Integer> initialize_linearFormatSignificant() {
        ES6Map<String, Integer> linearFormatSignificant = ES6Map.create();
        linearFormatSignificant.set("s", 1);
        linearFormatSignificant.set("g", 1);
        linearFormatSignificant.set("p", 1);
        linearFormatSignificant.set("r", 1);
        linearFormatSignificant.set("e", 1);
        return linearFormatSignificant;
    }

    private static int linearPrecision(double value) {
        return value == 0.0 ? 0 : (int)(-Math.floor(Math.log(value) / Math.log(10.0) + 0.01));
    }

    private static Number linearFormatPrecision(String type, ArrayEx<Object> range) {
        Double d = ObjectConverter.toDouble(range.get(2));
        int p = LinearScale.linearPrecision(d);
        if (linearFormatSignificant.get(type) != null) {
            int precision = LinearScale.linearPrecision(Math.max(Math.abs(ObjectConverter.toDouble(range.get(0))), Math.abs(ObjectConverter.toDouble(range.get(1)))));
            int typeValue = 0;
            if (!type.contains("e")) {
                typeValue = 1;
            }
            return Math.abs(p - precision + typeValue);
        }
        int typeValue = 0;
        if (type.equals("%")) {
            typeValue = 1;
        }
        return p - typeValue * 2;
    }
}

