/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.scales;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.internal.scales.Nice;
import com.ibm.rave.core.internal.scales.NiceIdentity;
import com.ibm.rave.core.interpolate.InterpolatorFactory;
import com.ibm.rave.core.locale.Locale;
import com.ibm.rave.core.locale.NumberFormat;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.selector.ValueFunction;
import java.util.List;

public class LogScale
extends AbstractScale<Object, Object> {
    public static Double DEFAULT_BASE = 10.0;
    private static volatile ValueFunction<Object, String> logFormat;
    private LinearScale _linear;
    private Double _base;
    private Boolean _positive;
    private ArrayEx<Object> _domain;
    private static NiceIdentity logNice;
    private static NiceIdentity logNiceNegative;
    private static RoundFunction ceilRoundFunc;
    private static RoundFunction floorRoundFunc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public LogScale(LinearScale linear, Number base, Boolean positive, ArrayEx<Object> domain) {
        this._linear = linear;
        this._base = ObjectConverter.asDouble(base);
        this._positive = positive;
        this._domain = domain;
        if (logFormat == null) {
            Class<LogScale> clazz = LogScale.class;
            // MONITORENTER : com.ibm.rave.core.scales.LogScale.class
            if (logFormat == null) {
                logFormat = new NumberFormat(Locale.DEFAULT_LOCALE).create(".0e");
            }
            // MONITOREXIT : clazz
        }
        final LogScale self = this;
        this.setTicks(new AbstractScale.TicksValueFunction(){

            @Override
            public ArrayEx<Object> getValue(Object ... tickArguments) {
                return self.logTicks(tickArguments);
            }
        });
        this.setTickFormat(new AbstractScale.TickFormatValueFunction(){

            @Override
            public ValueFunction<Object, String> getValue(Object ... tickArguments) {
                Double count = tickArguments.length > 0 ? Double.valueOf(ObjectConverter.toDouble(tickArguments[0])) : null;
                Object format = tickArguments.length > 1 ? tickArguments[1] : null;
                return self.logTickFormat(count, format);
            }
        });
        this.setInvert(new AbstractScale.InvertValueFunction<Object>(){

            @Override
            public Object getValue(Object y) {
                return self.pow(ObjectConverter.toDouble(self._linear.getInvert().getValue(y)));
            }
        });
    }

    @Override
    @SwiftMethodOverload(skipParameters={1}, skipOverloads={"Bool"})
    public Object getValue(Object context, Object data, int index, int groupIndex) {
        return this._linear.getValue(context, (Object)this.log(ObjectConverter.toDouble(data)), index, groupIndex);
    }

    public LogScale domain(List<Object> values) {
        this._positive = ObjectConverter.toDouble(values.get(0)) >= 0.0;
        this._domain = new ArrayEx(values.size());
        for (int i = 0; i < values.size(); ++i) {
            this._domain.set(i, ObjectConverter.toDouble(values.get(i)));
        }
        final LogScale self = this;
        this._linear.domain(this._domain.map(new ArrayEx.ArrayValueFunction<Object, Object>(){

            @Override
            public Object getValue(Object currentValue, int index, ArrayEx<Object> array) {
                return self.log(ObjectConverter.toDouble(currentValue));
            }
        }));
        return this;
    }

    @Override
    public ArrayEx<Object> domain() {
        return this._domain;
    }

    public LogScale range(List<Object> values) {
        this._linear.range((List)values);
        return this;
    }

    @Override
    public ArrayEx<Object> range() {
        return this._linear.range();
    }

    public LogScale copy() {
        return new LogScale(this._linear.copy(), this._base, this._positive, this._domain);
    }

    public LogScale clamp(boolean c) {
        this._linear.clamp(c);
        return this;
    }

    public boolean clamp() {
        return this._linear.clamp();
    }

    public LogScale rangeRound(List<Object> x) {
        this._linear.rangeRound(x);
        return this;
    }

    public LogScale interpolate(InterpolatorFactory<Object> interpolate) {
        this._linear.interpolate(interpolate);
        return this;
    }

    public Object interpolate() {
        return this._linear.interpolate();
    }

    public LogScale nice() {
        final LogScale self = this;
        ArrayEx<Object> niced = Nice.scaleNice(this._domain.map(new ArrayEx.ArrayValueFunction<Object, Object>(){

            @Override
            public Object getValue(Object currentValue, int index, ArrayEx<Object> array) {
                return self.log(ObjectConverter.toDouble(currentValue));
            }
        }), this._positive != false ? logNice : logNiceNegative);
        this._linear.domain(niced);
        this._domain = niced.map(new ArrayEx.ArrayValueFunction<Object, Object>(){

            @Override
            public Object getValue(Object currentValue, int index, ArrayEx<Object> array) {
                return self.pow(ObjectConverter.toDouble(currentValue));
            }
        });
        return this;
    }

    public LogScale base(Number b) {
        this._base = ObjectConverter.asDouble(b);
        return this;
    }

    public Number base() {
        return this._base;
    }

    private double log(double x) {
        return (this._positive != false ? Math.log(x < 0.0 ? 0.0 : x) : -Math.log(x > 0.0 ? 0.0 : -x)) / Math.log(this._base);
    }

    private double pow(double x) {
        return this._positive != false ? Math.pow(this._base, x) : -Math.pow(this._base, -x);
    }

    private ArrayEx<Object> logTicks(Object ... tickArguments) {
        double i;
        ArrayEx<Object> extent = AbstractScale.scaleExtent(this._domain);
        ArrayEx<Double> ticks = new ArrayEx<Double>();
        double u = ObjectConverter.toDouble(extent.get(0));
        double v = ObjectConverter.toDouble(extent.get(1));
        double j = Math.ceil(this.log(v));
        double n = this._base % 1.0 == 0.0 ? this._base : 2.0;
        Double delta = j - i;
        if (Lang.isFinite(delta)) {
            double k;
            if (this._positive.booleanValue()) {
                for (i = Math.floor(this.log(u)); i < j; i += 1.0) {
                    for (k = 1.0; k < n; k += 1.0) {
                        ticks.push(this.pow(i) * k);
                    }
                }
                ticks.push(this.pow(i));
            } else {
                ticks.push(this.pow(i));
                block2: while (true) {
                    double d = i;
                    i = d + 1.0;
                    if (!(d < j)) break;
                    k = n - 1.0;
                    while (true) {
                        if (!(k > 0.0)) continue block2;
                        ticks.push(this.pow(i) * k);
                        k -= 1.0;
                    }
                    break;
                }
            }
            i = 0.0;
            while ((Double)ticks.get((int)i) < u) {
                i += 1.0;
            }
            j = ticks.length();
            while ((Double)ticks.get((int)j - 1) > v) {
                j -= 1.0;
            }
            ticks = ticks.slice((int)i, (int)j);
        }
        return ObjectConverter.numberArrayAsObjectArray(ticks);
    }

    private ValueFunction<Object, String> logTickFormat(Number count, Object formatter) {
        if (count == null && formatter == null) {
            return logFormat;
        }
        final ValueFunction<Object, String> format = formatter == null ? logFormat : (formatter instanceof ValueFunction ? (ValueFunction<Object, String>)formatter : new NumberFormat(Locale.DEFAULT_LOCALE).create(ObjectConverter.toString(formatter)));
        Double n = ObjectConverter.toDouble(count);
        final Double k = Math.max(0.1, n / (double)this.getTicks().getValue(new Object[0]).size());
        final Double e = this._positive != false ? 1.0E-12 : -1.0E-12;
        final RoundFunction f = this._positive != false ? ceilRoundFunc : floorRoundFunc;
        final LogScale self = this;
        return new ValueFunction<Object, String>(){

            @Override
            public String getValue(Object context, Object data, int index, int groupIndex) {
                double value = ObjectConverter.toDouble(data);
                return value / self.pow(f.round(self.log(value) + e)) <= k ? (String)format.getValue(context, value, index, groupIndex) : "";
            }
        };
    }

    static {
        logNice = new NiceIdentity(new Nice.ValueFunction(){

            @Override
            public Number getValue(Number x) {
                return Math.floor(ObjectConverter.asDouble(x));
            }
        }, new Nice.ValueFunction(){

            @Override
            public Number getValue(Number x) {
                return Math.ceil(ObjectConverter.asDouble(x));
            }
        });
        logNiceNegative = new NiceIdentity(new Nice.ValueFunction(){

            @Override
            public Number getValue(Number x) {
                return -Math.ceil(-ObjectConverter.asDouble(x).doubleValue());
            }
        }, new Nice.ValueFunction(){

            @Override
            public Number getValue(Number x) {
                return -Math.floor(-ObjectConverter.asDouble(x).doubleValue());
            }
        });
        ceilRoundFunc = new RoundFunction(){

            @Override
            public double round(double v) {
                return Math.ceil(v);
            }
        };
        floorRoundFunc = new RoundFunction(){

            @Override
            public double round(double v) {
                return Math.floor(v);
            }
        };
    }

    @FunctionClass(value="round")
    @SwiftClosure(value="round")
    private static interface RoundFunction {
        public double round(double var1);
    }
}

