/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.scales;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.interpolate.InterpolatorFactory;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.selector.ValueFunction;
import java.util.List;

public class PowScale
extends AbstractScale<Object, Object> {
    private LinearScale _linear;
    private Double _exponent;
    private ArrayEx<Object> _domain;
    private PowValueFunction powp;
    private PowValueFunction powb;

    public PowScale(LinearScale linear, Number exponent, ArrayEx<Object> domain) {
        this._linear = linear;
        this._exponent = ObjectConverter.asDouble(exponent);
        this._domain = domain;
        this.powp = PowScale.pow(this._exponent);
        this.powb = PowScale.pow(1.0 / this._exponent);
        final PowScale self = this;
        this.setTicks(new AbstractScale.TicksValueFunction(){

            @Override
            public ArrayEx<Object> getValue(Object ... tickArguments) {
                return LinearScale.linearTicks(self._domain, tickArguments);
            }
        });
        this.setTickFormat(new AbstractScale.TickFormatValueFunction(){

            @Override
            public ValueFunction<Object, String> getValue(Object ... tickArguments) {
                Double count = tickArguments.length > 0 ? Double.valueOf(ObjectConverter.toDouble(tickArguments[0])) : null;
                Object format = tickArguments.length > 1 ? tickArguments[1] : null;
                return LinearScale.linearTickFormat(self._domain, count, format instanceof String ? (String)format : null);
            }
        });
        this.setInvert(new AbstractScale.InvertValueFunction<Object>(){

            @Override
            public Object getValue(Object y) {
                return self.powb.exp(ObjectConverter.toDouble(self._linear.getInvert().getValue(y)));
            }
        });
    }

    @Override
    @SwiftMethodOverload(skipParameters={1}, skipOverloads={"Bool"})
    public Object getValue(Object context, Object data, int index, int groupIndex) {
        return this._linear.getValue(context, (Object)this.powp.exp(ObjectConverter.toDouble(data)), index, groupIndex);
    }

    public PowScale domain(List<Object> values) {
        this._domain = new ArrayEx(values.size());
        for (int i = 0; i < values.size(); ++i) {
            this._domain.set(i, ObjectConverter.toDouble(values.get(i)));
        }
        final PowScale self = this;
        this._linear.domain(this._domain.map(new ArrayEx.ArrayValueFunction<Object, Object>(){

            @Override
            public Object getValue(Object currentValue, int index, ArrayEx<Object> array) {
                return self.powp.exp(ObjectConverter.toDouble(currentValue));
            }
        }));
        return this;
    }

    @Override
    public ArrayEx<Object> domain() {
        return this._domain;
    }

    public PowScale range(List<Object> values) {
        this._linear.range((List)values);
        return this;
    }

    @Override
    public List<Object> range() {
        return this._linear.range();
    }

    public PowScale copy() {
        return new PowScale(this._linear.copy(), this._exponent, this._domain);
    }

    public PowScale clamp(boolean c) {
        this._linear.clamp(c);
        return this;
    }

    public boolean clamp() {
        return this._linear.clamp();
    }

    public PowScale rangeRound(List<Object> x) {
        this._linear.rangeRound(x);
        return this;
    }

    public PowScale interpolate(InterpolatorFactory<Object> interpolate) {
        this._linear.interpolate(interpolate);
        return this;
    }

    public Object interpolate() {
        return this._linear.interpolate();
    }

    public PowScale nice() {
        return this.nice(10);
    }

    public PowScale nice(Number m) {
        return this.domain(LinearScale.linearNice(this._domain, m));
    }

    public Number exponent() {
        return this._exponent;
    }

    public PowScale exponent(Number x) {
        this._exponent = ObjectConverter.asDouble(x);
        this.powp = PowScale.pow(this._exponent);
        this.powb = PowScale.pow(1.0 / this._exponent);
        final PowScale self = this;
        this._linear.domain(this._domain.map(new ArrayEx.ArrayValueFunction<Object, Object>(){

            @Override
            public Object getValue(Object currentValue, int index, ArrayEx<Object> array) {
                return self.powp.exp(ObjectConverter.toDouble(currentValue));
            }
        }));
        return this;
    }

    private static PowValueFunction pow(final double e) {
        return new PowValueFunction(){

            @Override
            public double exp(double x) {
                return x < 0.0 ? -Math.pow(-x, e) : Math.pow(x, e);
            }
        };
    }

    @FunctionClass(value="exp")
    @SwiftClosure(value="exp")
    private static interface PowValueFunction {
        public double exp(double var1);
    }
}

